<?php

namespace App\Models;

use App\Traits\DianujHashidsTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Cards extends Model
{
    use HasFactory;
    use SoftDeletes;
    use DianujHashidsTrait;

    // function CardCategories(){
    //     return $this->belongsTo(Fortend.CardCategories::class,'category');
    // }

    public function CardCategories()
    {
        return $this->belongsTo(CardCategories::class, 'category');
    }


    public function userCard()
    {
        return $this->hasOne(UserCard::class, 'card_id', 'id')
                    ->where('user_id', auth('web')->id()); // Filter by authenticated user
    }

    public function CardCategory()
    {
        return $this->belongsTo(CardCategories::class, 'category');
    }
    public function exam()
    {
        return $this->belongsTo(CardExam::class, 'id');
    }

    public function userTests()
    {
        return $this->hasMany(UserTest::class, 'id'); 
    }
   

}
