<?php

namespace App\Models;

use App\Models\StudentRegistration;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Traits\DianujHashidsTrait;

class PartnerInvoice extends Model
{
    use HasFactory;
    use SoftDeletes;
    use DianujHashidsTrait;

    protected $fillable = ['invoice_number', 'invoice_price', 'partner_id'];

    public function studentRegistrations()
    {
        return $this->hasMany(StudentRegistration::class, 'invoice_id');
    }
   
}
