<style>
    #timer {
        font-size: 25px;
        font-weight: bold;
    }
</style>
@extends('layouts.front')
@section('page-css')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
    <!-- Bootstrap Select Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/bootstrap-select/css/bootstrap-select.css" />
@endsection
@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="body">

                            <div class="d-flex justify-content-between align-items-center">
                                <h4>Exam: {{ $examName }}</h4>
                                <div class="d-flex flex-column align-items-end">
                                    <span class="text-muted">Time Remaining</span>
                                    <div id="timer" style="font-size: 25px;"><strong></strong></div>
                                    <div id="message" style="color: red; display: none;">Exam time finished</div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <form id="examForm">
                            <div id="add_exam_q">
                                @csrf
                                <input type="hidden" name="user_test_id" value="{{ $user_test_id }}">
                                <input type="hidden" name="question_id" value="{{ $firstQuestion->id }}">

                                <div class="body mt-3">
                                    <div class="row clearfix">
                                        <div class="col-sm-12">
                                            @if ($firstQuestion)
                                                <div class="form-group">
                                                    <div class="d-flex justify-content-between align-items-center"
                                                        style="font-size: 20px;">
                                                        <span>Question</span>
                                                        <span><strong>{{ $answeredQuestionsCount +1 }}/{{ $totalQuestions }}</strong></span>
                                                    </div>
                                                    <h4>{{ $firstQuestion->question }}</h4>
                                                </div>

                                                @foreach ($firstQuestion->options as $option)
                                                    <div class="option-box p-3 mb-3 border rounded">
                                                        <div class="form-check">
                                                            <input class="form-check-input"
                                                                type="{{ $firstQuestion->type }}"
                                                                name="user_selected_answer"
                                                                value="{{ $option->answer_options }}"
                                                                id="option{{ $option->id }}">
                                                            <label class="form-check-label"
                                                                for="option{{ $option->id }}">
                                                                {{ $option->answer_options }}
                                                            </label>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            @else
                                                <p>No questions available.</p>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-center mt-4 form-submit-btn">
                                        <button type="submit"
                                            class="btn btn-raised btn-primary btn-round waves-effect form-submit-btn">Submit</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </section>
@endsection

@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>
    <!-- Timer Script -->

    <script>
        function startTimer(display) {
            var endTime = localStorage.getItem('endTime');
            var examSubmitted = localStorage.getItem('examSubmitted');
    
            if (!endTime || examSubmitted) {
                var duration = 60 * 60; // 10 minutes
                endTime = Date.now() + duration * 1000;
                localStorage.setItem('endTime', endTime);
                localStorage.removeItem('examSubmitted'); // Clear exam submitted flag
            }
    
            function updateTimer() {
                var remainingTime = Math.floor((endTime - Date.now()) / 1000);
    
                if (remainingTime <= 0) {
                    display.textContent = "00:00";
                    document.getElementById('message').style.display = 'block';
    
                    clearInterval(interval);
                    localStorage.removeItem('endTime');
    
                    var userTestId = '{{ $user_test_id }}';
                    var token = '{{ csrf_token() }}';
    
                    $.ajax({
                        url: '{{ route('user.cards.updateStatus') }}',
                        type: 'POST',
                        data: {
                            _token: token,
                            user_test_id: userTestId,
                            status: 'complete'
                        },
                        success: function(response) {
                            if (response.success) {
                                setTimeout(function() {
                                    window.location.href = '{{ route('user.cards.mycard') }}';
                                }, 1000);
                            }
                        },
                        error: function(xhr) {
                            console.error('Error updating exam status:', xhr.responseText);
                        }
                    });
    
                    return;
                }
    
                var minutes = Math.floor(remainingTime / 60);
                var seconds = remainingTime % 60;
    
                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;
    
                display.textContent = minutes + ":" + seconds;
            }
    
            var interval = setInterval(updateTimer, 1000);
        }
    
        window.onload = function() {
            var display = document.querySelector('#timer strong');
            startTimer(display);
        };
    </script>
    

    <script>
        $(document).ready(function() {
            $('#examForm').on('submit', function(event) {
                event.preventDefault();
    
                var formData = $(this).serialize();
                var submitBtn = $('.form-submit-btn');
                submitBtn.prop('disabled', true);
                submitBtn.html(
                    '<span class="d-flex align-items-center"><div class="spinner-border text-dark" role="status"><span class="sr-only">Loading...</span> </div> Saving...</span>'
                );
    
                $.ajax({
                    url: '{{ route('user.cards.attempt') }}',
                    method: 'POST',
                    data: formData,
                    success: function(response) {
                        submitBtn.prop('disabled', false);
                        submitBtn.html('Save');
                        if (response.status) {
                            if (response.complete) {
                                $.ajax({
                                    url: '{{ route('user.cards.updateStatus') }}',
                                    method: 'POST',
                                    data: {
                                        _token: '{{ csrf_token() }}',
                                        user_test_id: $('input[name="user_test_id"]').val(),
                                        status: 'complete'
                                    },
                                    success: function(res) {
                                        if (res.success) {
                                            localStorage.setItem('examSubmitted', true); // Set exam submitted flag
                                            window.location.href = '{{ route('user.cards.mycard') }}';
                                        }
                                    },
                                    error: function(xhr) {
                                        alert('Error updating exam status: ' + xhr.responseText);
                                    }
                                });
                            } else {
                                $('#add_exam_q').html(response.question);
    
                                if (response.user_test_id) {
                                    $('#add_exam_q').find('input[name="user_test_id"]').val(response.user_test_id);
                                }
                            }
                        } else {
                            alert(response.message);
                        }
                    },
                    error: function(xhr) {
                        alert('Error saving answer: ' + xhr.responseText);
                    }
                });
            });
        });
    </script>
    
@endsection
