<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    // use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/login';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest:web')->except('logout');
    }

    public function login(Request $request)
    {

        $a = $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required'
        ]);
        // if (Auth::guard('web')->attempt(['email' => $request->email, 'password' => $request->password], $request->remember)) {
        //     return redirect()->intended(url('/user/'));
        // }


        if (Auth::guard('web')->attempt(['email' => $request->email, 'password' => $request->password], $request->remember)) {

            // Get the authenticated user
            $user = Auth::guard('web')->user();

            // Check the usertype and redirect accordingly
            if ($user->user_type == 'partner') {
                return redirect()->intended(url('/user/'));
            } elseif ($user->user_type == 'individual_user') {
                return redirect()->route('user.cards.all');
            }

            // Fallback, in case usertype is not matched (optional)
            return redirect()->intended(url('/default-route'));
        }
        return redirect()->back()->withInput()->withErrors(['email' => 'These credentials do not match our records.']);
    }

    public function showLoginForm()
    {
        return view('auth.login');
    }

    // public function partnerlogout(Request $request)
    // {
    //     Auth::guard('web')->logout();

    //     $request->session()->invalidate();

    //     $request->session()->regenerateToken();

    //     return $request->wantsJson()
    //         ? new JsonResponse([], 204)
    //         // : redirect('/partner_login');
    //         : redirect()->route('auth.partner_login');
    // }
    public function partnerlogout(Request $request)
    {

        Auth::guard('web')->logout();

        return redirect()->route('partner_login');
    }
    
    public function logout(Request $request)
    {
        auth('web')->logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return $request->wantsJson()
            ? new JsonResponse([], 204)
            : redirect(url('/user/login'));
    }

}
