<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Mail\VerificationEmail;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;
    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */


    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */

    public function register(Request $request)
    {
        $rules = [
            'institute_name' => 'required|string|max:50',
            'head_institute' => 'required|string|max:50',
            'city' => 'required|string|max:50',
            'country' => 'required|string|max:50',
            'phone_number' => 'required|numeric',
            'address' => 'required',
            'email' => 'required|string|email|max:255|unique:users',
            'pdf' => 'required|mimes:pdf|max:2048',
            'password' => 'required|min:8|max:12',
            'confirm_password' => 'required|same:password'
        ];
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator);
        }

        try {
            DB::beginTransaction();

            $create_user = new User;
            $create_user->institute_name = $request->institute_name;
            $create_user->head_institute = $request->head_institute;
            $create_user->phone_number = $request->phone_number;
            $create_user->email = $request->email;
            $create_user->address = $request->address;
            $create_user->city = $request->city;
            $create_user->country = $request->country;
            $create_user->website = $request->website;
            $create_user->business_registration = $request->business_registration;
            $create_user->user_name = 'institute-'.strtolower($request->institute_name);
            $create_user->is_verified = "0";
            $create_user->password = Hash::make($request->password);
            $create_user->email_verified_at = now();

            if ($request->hasFile('pdf')) {
                $pdf_file = uploadSingleFile($request->file('pdf'), 'uploads/client/pdf_files', 'pdf');
                $create_user->pdf = $pdf_file;
            }
            $create_user->save();
            DB::commit();

            return redirect()->route('register.approval');
        } catch (\Exception $e) {  dd($e->getMessage());
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['error' => $e->getMessage()]);
        }
    }
    public function showRegistrationForm()
    {
        $data = [
        ];
        return view('auth.register', $data);
    }

    public function showLoginForm()
    {

        $data = [
        ];
        return view('auth.partner_login', $data);
    }

    public function registeration_approval()
    {
        return view('auth.registeration_approval');
    }
    public function success_message()
    {
        $data = array(
            'title' => 'Success Message',
        );
        return view('auth.success_message', $data);
    }

    public function password_screen($id)
    {
        $data = array(
            'title'  => 'Set Password',
            'user_id' => $id,
        );
        return view('auth.set_password', $data);
    }
    public function UserregisterForm()
    {
        $data = [
        ];
        return view('auth.User_register', $data);
    }

    public function Userregister(Request $request)
    {
        $rules = [
            'full_name' => 'required|string|max:50',
            'date_of_birth' => 'required',
            'profession' => 'required|string|max:50',
            'experience' => 'required|string|max:50',
            'country' => 'required|string|max:50',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|min:8|max:12',
            'confirm_password' => 'required|same:password',
            'profile_image' => 'required|image|mimes:png,jpeg,jpg|max:2048'
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            return redirect()->back()->withInput()->withErrors($validator);
        }

        try {
            DB::beginTransaction();

            $create_user = new User;
            $create_user->full_name = $request->full_name;
            $create_user->date_of_birth = $request->date_of_birth;
            $create_user->profession = $request->profession;
            $create_user->experience = $request->experience;
            $create_user->country = $request->country;
            $create_user->email = $request->email;
            $create_user->user_name = 'user-' . strtolower($request->full_name);
            $create_user->user_type = "individual_user";
            $create_user->password = Hash::make($request->password);
            $create_user->email_verified_at = now();

            if ($request->hasFile('profile_image')) {
                // Ensure file type validation
                $file = $request->file('profile_image');
                $fileExtension = $file->getClientOriginalExtension();
                $allowedExtensions = ['png', 'jpeg', 'jpg'];

                if (!in_array($fileExtension, $allowedExtensions)) {
                    return redirect()->back()->withInput()->withErrors(['profile_image' => 'Invalid image format.']);
                }

                // File upload function
                // $profile_img = $file->store('uploads/client/profile_images', 'public');
                $profile_img = uploadSingleFile($request->file('profile_image'), 'uploads/client/profile_images/', 'png,jpeg,jpg');

                if (file_exists(public_path('storage/' . $create_user->profile_image))) {
                    @unlink(public_path('storage/' . $create_user->profile_image));
                }
                $create_user->profile_image = $profile_img;
            }

            $create_user->save();
            DB::commit();

            if (Auth::guard('web')->attempt(['email' => $request->email, 'password' => $request->password], $request->remember)) {
                return redirect()->route('user.cards.all');
            }
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->withInput()->withErrors(['error' => $e->getMessage()]);
        }
    }
}
