<?php

namespace App\Http\Controllers\Frontend;

use App\Helpers\CommonHelpers;
use App\Http\Controllers\Controller;
use Google\Service\Docs\Request;

class PartnerApprovePaymentController extends Controller
{
    public function link_page($id)
    {
        return view('admin.link_page');
    }

    public function create_payment(Request $request)
    {
        // $amt = Order::hashidFind($request->order_id);
        $access_token = json_decode(CommonHelpers::payment_request())->access_token;
        $data = array(
            'intent' => 'sale',
            'payer' =>
            array(
                'payment_method' => 'paypal',
            ),
            'transactions' =>
            array(
                0 =>
                array(
                    'amount' =>
                    array(
                        'currency' => 'EUR',
                        'total' => number_format(100, 2),
                    ),
                    'description' => 'This is the payment transaction description',
                    'payment_options' =>
                    array(
                        'allowed_payment_method' => 'IMMEDIATE_PAY',
                    ),
                ),
            ),
            'redirect_urls' =>
            array(
                'return_url' => route('approvePayment.order_success_update', 1),
                'cancel_url' => 'https://example.com/cancel',
            ),
        );
        $payment = CommonHelpers::payment_request($data, $access_token);
    }

    public function order_success(Request $request)
    {
        $data = array(
            'title' => 'order-success',
        );
        return view('front.order_place')->with($data);
    }

    public function order_success_update(request $request)
    {
        $paypal_data = json_decode($request->order_data);
    }
}
