<?php

namespace App\Models;

use App\Traits\DianujHashidsTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CardExamQuestion extends Model
{
    use HasFactory, SoftDeletes, DianujHashidsTrait;
    protected $fillable = [];

    public function cardExam()
    {
        return $this->belongsTo(CardExam::class, 'card_exam_id', 'id');
    }
    public function QuestionOptions()
    {
        return $this->hasMany(QuestionOption::class, 'question_id', 'id');
    }
}
