@extends('layouts.admin')
@section('page-css')
<!-- JQuery DataTable Css -->
<link rel="stylesheet" href="{{asset('front')}}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection
@section('content')
<section class="content">
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-lg-5 col-md-5 col-sm-12">
                    <h2>{{$title}}</h2>
                    <ul class="breadcrumb padding-0">
                        <li class="breadcrumb-item"><a href="index.html"><i class="zmdi zmdi-home"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.home')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">{{$title}}</li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="row clearfix">
            <div class="col-lg-12">
                <div class="card">
                    <div class="body">
                        <h2 class="card-inside-title">{{$sub_title}}</h2>
                        <form action="{{route('admin.course.save')}}" method="post" class="ajaxForm">
                            @csrf
                            <div class="row clearfix">
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Course Code</label>
                                        <input type="number" class="form-control" placeholder="course code"
                                            name="course_id" value="{{ $edit->course_id ?? '' }}" />
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Course Name</label>
                                        <input type="text" class="form-control" placeholder="Course Name"
                                            name="course_name" value="{{ $edit->course_name ?? '' }}" />
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="">Course price</label>
                                        <input type="number" class="form-control" placeholder="Course price"
                                            name="course_price" value="{{ $edit->course_price ?? '' }}" />
                                    </div>
                                </div>
                                <input type="hidden" value="{{$edit->id ?? ''}}" name="id">
                            </div>
                            @if(!isset($edit->id))
                            <br>
                            <div class="row mb-4">
                                <div class="form-check">
                                    <input type="checkbox" name="check_next" id="stayOnPage" value="1">
                                    <label class="form-check-label" for="stayOnPage">
                                        Stay On this page after i clicked <strong>Save</strong>
                                    </label>
                                </div>
                            </div>
                            @endif
                            <button type="submit"
                            class="btn btn-raised btn-primary btn-round waves-effect form-submit-btn">
                        {{ isset($edit) ? 'Update' : 'Save' }}
                    </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
@section('page-scripts')
<!-- Jquery DataTable Plugin Js -->
<script src="{{asset('front')}}/assets/bundles/datatablescripts.bundle.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
<script src="{{asset('front')}}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
<script src="{{asset('front')}}/assets/js/pages/tables/jquery-datatable.js"></script>
<script>
    $('.ajaxForm').submit(function(e) {
        e.preventDefault();
        var url = $(this).attr('action');
        var param = new FormData(this);
        my_ajax(url, param, 'post', function(res) {}, true);
    });
</script>
@endsection