@extends('layouts.admin')
@section('page-css')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
    <!-- Bootstrap Select Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/bootstrap-select/css/bootstrap-select.css" />
@endsection

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="index.html"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <form action="{{ route('admin.exam.save') }}" method="post" class="ajaxForm">
                            @csrf
                            <div class="d-flex justify-content-between align-items-center">
                                <h2 class="card-inside-title">{{ $sub_title }}</h2>

                            </div>
                            <input type="hidden" value="{{ @$edit->id }}" name="id">
                            <div class="body">
                                <div class="row clearfix">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="">Card</label>
                                            <select name="card_id" class="form-control z-index show-tick">
                                                <option value="" selected disabled>Select...</option>
                                                @foreach ($cards as $card)
                                                    <option value="{{ $card->id }}"
                                                        {{ @$edit->card_id == $card->id ? 'selected' : '' }}>
                                                        {{ $card->title }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="">Title</label>
                                            <input type="text" name="title" class="form-control"
                                                value="{{ @$edit->title }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="body mt-5">
                                <div class="row clearfix">
                                    <div class="col-sm-12">
                                        <div class="form-group">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <h5>Exam Questions:</h5>
                                                  <button type="submit"
                                            class="btn btn-raised btn-primary form-submit-btn">Save</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @if (isset($edit->id))
                                <div id="add_row">
                                    @foreach ($edit->CardExamQuestion as $i => $val)
                                        <div class="body mt-5 question-row">
                                            <div class="row clearfix">
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <!--<button type="button"-->
                                                        <!--    class="float-right btn btn-danger delete-question"-->
                                                        <!--    style="font-size: 15px;">-->
                                                        <!--    <i class="fas fa-trash"></i>-->
                                                        <!--</button>-->
                                                        <h4 class="question_count">Question({{ ++$i }})</h4>

                                                        <label for="">Question*</label>
                                                        <textarea name="question[{{ $i }}][question]" id="" cols="20" rows="5"
                                                            placeholder="Enter Question" class="form-control" style="border: 1px solid grey;">{{ $val->question }}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row clearfix">
                                                {{-- <div class="col-sm-6">
                                                    <div class="form-group">
                                                        <label for="">Type</label>
                                                        <select name="question[{{ $i }}][type]" id=""
                                                            class="form-control">
                                                            <option value="radio"
                                                                {{ $val->type == 'radio' ? 'selected' : '' }}>Radio
                                                            </option>
                                                            <option value="check"
                                                                {{ $val->type == 'check' ? 'selected' : '' }}>Checkbox
                                                            </option>
                                                        </select>
                                                    </div>
                                                </div> --}}
                                                <!--<div class="col-sm-12">-->
                                                <!--    <div class="form-group">-->

                                                <!--        <label for="">Correct Answer</label>-->
                                                <!--        <select name="question[{{ $i }}][correct_answer]"-->
                                                <!--            id="" class="form-control">-->
                                                <!--            <option value="1">Option 1</option>-->
                                                <!--            <option value="2">Option 2</option>-->
                                                <!--            <option value="3">Option 3</option>-->
                                                <!--            <option value="4">Option 4</option>-->
                                                <!--        </select>-->

                                                <!--    </div>-->
                                                <!--</div>-->
                                                
                                                <div class="col-sm-12">
                                                    <div class="form-group">
                                                        <label for="">Correct Answer</label>
                                                        <select name="question[{{ $i }}][correct_answer]" id="" class="form-control">
                                                            <option value="1" {{ $val->correct_answer_number == 1 ? 'selected' : '' }}>Option 1</option>
                                                            <option value="2" {{ $val->correct_answer_number == 2 ? 'selected' : '' }}>Option 2</option>
                                                            <option value="3" {{ $val->correct_answer_number == 3 ? 'selected' : '' }}>Option 3</option>
                                                            <option value="4" {{ $val->correct_answer_number == 4 ? 'selected' : '' }}>Option 4</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row clearfix">
                                                @foreach ($val->QuestionOptions as $key => $option)
                                                    <div class="col-sm-6">
                                                        <div class="form-group">
                                                            <label for="">Option {{ ++$key }}:</label>
                                                            <input type="text" class="form-control"
                                                                placeholder="Option {{ $key }}"
                                                                name="question[{{ $i }}][option_{{ $key }}]"
                                                                value="{{ $option->option }}" />

                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                @for ($i = 1; $i <= 100; $i++)
                                    <div class="body mt-5 question-row" id="add_row">
                                        <div class="row clearfix">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <!--<button type="button"-->
                                                    <!--    class="float-right btn btn-danger delete-question"-->
                                                    <!--    style="font-size: 15px;">-->
                                                    <!--    <i class="fas fa-trash"></i>-->
                                                    <!--</button>-->
                                                    <h4 class="question_count">Question({{ $i }})</h4>

                                                    <label for="">Question*</label>
                                                    <textarea name="question[{{ $i }}][question]" id="" cols="20" rows="5"
                                                        placeholder="Enter Question" class="form-control" style="border: 1px solid grey;"></textarea>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row clearfix">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">Option 1:</label>
                                                    <input type="text" class="form-control" placeholder="Option 1"
                                                        name="question[{{ $i }}][option_1]"
                                                        value="{{ $edit->price ?? '' }}" />
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">Option 2:</label>
                                                    <input type="text" class="form-control" placeholder="Option 2"
                                                        name="question[{{ $i }}][option_2]"
                                                        value="{{ $edit->price ?? '' }}" />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row clearfix">
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">Option 3:</label>
                                                    <input type="text" class="form-control" placeholder="Option 3"
                                                        name="question[{{ $i }}][option_3]"
                                                        value="{{ $edit->price ?? '' }}" />
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group">
                                                    <label for="">Option 4:</label>
                                                    <input type="text" class="form-control" placeholder="Option 4"
                                                        name="question[{{ $i }}][option_4]"
                                                        value="{{ $edit->price ?? '' }}" />
                                                </div>
                                            </div>

                                        </div>
                                        <div class="row clearfix">
                                            <div class="col-sm-12">
                                                <div class="form-group">
                                                    <label for="">Correct Answer</label>
                                                    <select name="question[{{ $i }}][correct_answer]"
                                                        id="" class="form-control">
                                                        <option value="1">Option 1</option>
                                                        <option value="2">Option 2</option>
                                                        <option value="3">Option 3</option>
                                                        <option value="4">Option 4</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endfor
                            @endif
                            <div class="row clearfix mt-3">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <!--<div class="btn btn-primary" style="font-size: 15px;" id="add_question">-->
                                            <!--    <i class="fas fa-plus"></i>&nbsp; Question-->
                                            <!--</div>-->
                                            <button type="submit"
                                                class="btn btn-raised btn-primary form-submit-btn">Save</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>


    <script>
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {}, true);
        });
    </script>
    <script>
        var row_num = {{ $i }};
        $(document).on('click', '#add_question', function() {
            console.log(row_num);

            let questionHtml = `<div class="body mt-5 question-row">
            <div class="row clearfix">
                <div class="col-sm-12">
                    <div class="form-group">
                        // <button type="button" class="float-right btn btn-danger delete-question" style="font-size: 15px;">
                        //     <i class="fas fa-trash"></i>
                        // </button>
                        <h4 class="question_count">Question</h4>
                        <label for="">Question*</label>
                        <textarea name="question[${row_num}][question]" cols="20" rows="5" placeholder="Enter Question" class="form-control" style="border: 1px solid grey;"></textarea>
                    </div>
                </div>
            </div>


            <div class="row clearfix">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="">Option 1:</label>
                        <input type="text" class="form-control" placeholder="Option 1" name="question[${row_num}][option_1]" />
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="">Option 2:</label>
                        <input type="text" class="form-control" placeholder="Option 2" name="question[${row_num}][option_2]" />
                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="">Option 3:</label>
                        <input type="text" class="form-control" placeholder="Option 3" name="question[${row_num}][option_3]" />
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="">Option 4:</label>
                        <input type="text" class="form-control" placeholder="Option 4" name="question[${row_num}][option_4]" />
                    </div>
                </div>

            </div>
            <div class="row clearfix">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="">Correct Answer</label>
                         <select name="question[${row_num}][correct_answer]"
                            id="" class="form-control">
                            <option value="1">Option 1</option>
                            <option value="2">Option 2</option>
                            <option value="3">Option 3</option>
                            <option value="4">Option 4</option>
                        </select>
                    </div>
                </div>

            </div>
        </div>`;
            $('#add_row').append(questionHtml);
            resetIndexText();
            row_num++;
        });
        $(document).on('click', '.delete-question', function() {
            $(this).closest('.body').remove();
            resetIndexText();
        });

        function resetIndexText() {
            var rowCount = 1;
            $("body .question_count").each(function(i, obj) {
                $(obj).html(`Question (${rowCount})`);
                rowCount++;
            });
        }
    </script>
@endsection
