@section('title', 'SetUp Password')

@section('content')
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Setup -Oshta</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-container {
            max-width: 500px;
            margin: 5% auto;
            padding: 2rem;
            background-color: #ffffff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        .logo-size {
            max-width: 150px;
            margin-bottom: 1.5rem;
        }
        .form-control {
            border-radius: 30px;
        }
        .btn-primary {
            border-radius: 30px;
        }
        .form-label {
            font-weight: 500;
            color: #495057;
        }
        .icon-wrapper {
            position: absolute;
            top: 50%;
            left: 10px;
            transform: translateY(-50%);
            color: #6c757d;
        }
        .form-group {
            position: relative;
        }
        .card-title {
            font-size: 1.25rem;
            font-weight: 500;
        }
        .card-text {
            font-size: 1rem;
            color: #6c757d;
        }
    </style>
</head>
<body>
    
    <div class="container">
        <div class="form-container">
            <img class="logo-size" src="{{ asset('front/assets/images/OSHTA-Logo.png') }}" alt="Logo">
            <h5 class="card-title">Set A New Password</h5>
            <p class="card-text mb-5">Set up a password for your account.</p>
            <form method="POST" action="{{ route('admin.save_new_password') }}">
                @csrf
                <div class="mb-3 form-group">
                    
                    <div class="input-group">
                        <span class="input-group-text icon-wrapper"><i class="bi bi-lock-fill"></i></span>
                        <input type="password" class="form-control" name="password" value="{{ old('password') }}" id="inputNewPassword" placeholder="Enter New Password" required>
                    </div>
                    @error('password')
                        <div class="text-danger mt-1">{{ $message }}</div>
                    @enderror
                </div>
                <div class="mb-3 form-group">
                   
                    <div class="input-group">
                        <span class="input-group-text icon-wrapper"><i class="bi bi-lock-fill"></i></span>
                        <input type="password" class="form-control" name="confirm_password" value="{{ old('confirm_password') }}" id="inputConfirmPassword" placeholder="Confirm New Password" required>
                    </div>
                    @error('confirm_password')
                        <div class="text-danger mt-1">{{ $message }}</div>
                    @enderror
                </div>
                <input type="hidden" value="{{ $user_id }}" name="user_id">
                <button type="submit" class="btn btn-primary w-100">Save Password</button>
            </form>
        </div>
    </div>
    <div class="login-image-div-monkey">
    <img src="{{ asset('front') }}/assets/css/images/login_mbl_image2.png" class="monkey_image" alt="">
    </div>
    
    <div class="login-image-div">
    <img src="{{ asset('front') }}/assets/css/images/login_mbl_image1.png" class="footer_image" alt="">
    </div>
   
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
