@extends('layouts.front')
@section('page-css')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection
@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="index.html"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- Basic Examples -->
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div id="paypal-button"></div>
                        {{-- <form action="{{ route('user.payment.create_payment') }}" method="post">
                            @csrf
                            <input type="hidden" name="price" value="5">
                            <input type="hidden" name="product_name" value="Laptop">
                            <input type="hidden" name="quantity" value="1">
                            <button type="submit">Pay with payPal</button>
                        </form> --}}
                        <div class="body">
                            <div class="table-responsive">
                                <table id="course-table"
                                    class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                    <thead>
                                        <tr>
                                            <th>S.no</th>
                                            <th>invoice Date</th>
                                            <th>invoice Number</th>
                                            <th>Number of students</th>
                                            <th>Price</th>
                                            <th>Payment Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($invoices as $invoice)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $invoice->created_at->format('d-m-Y') }}</td>
                                                <td>{{ $invoice->invoice_number }}</td>
                                                <td>{{ $invoice->students_count }}</td>
                                                <td>{{ $invoice->invoice_price }}</td>
                                                <td>
                                                    @if ($invoice->payment_status === 'paid')
                                                        <span class="badge badge-success">Paid</span>
                                                    @else
                                                    {{-- <button id="paypal-button" class="btn btn-danger trigger-payment-modal"
                                                        data-toggle="modal" data-target="#invoiceModal" data-id="{{ $invoice->id }}">Pay Now</button> --}}

                                                        {{-- <button type="button" class="btn btn-warning approveModal"
                                                            data-data="{{ $invoice }}">
                                                            Pay Now
                                                        </button> --}}

                                                        <button type="button" class="btn btn-warning approveModal"
                                                            data-toggle="modal" data-target="#approveModal"
                                                            data-id="{{ $invoice->id }}" data-partner-name="{{ $invoice->partner_name }}">
                                                            Pay Now
                                                        </button>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($invoice->payment_status == 'paid')
                                                        <a href="{{ route('user.invoice.view', $invoice->hashid) }}"
                                                           class="button button-small view_partner_details" title="View">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    @else
                                                       <span class="badge badge-danger">Unpaid</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Approve Modal -->
    <div class="modal fade" id="approveModal" tabindex="-1" role="dialog" aria-labelledby="approveModalLabel"
    aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="approveModalLabel">Approve Partner</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to approve <strong id="partnerName"></strong></p>
                <form id="approvalForm" action="" class="ajaxForm">
                    @csrf
                    <input type="hidden" name="id" id="partnerId">
                    <input type="hidden" name="approved" id="approvedType">
                    <div class="d-flex justify-content-between w-100">
                        <button type="submit" class="btn btn-primary" data-approve-type="withPayment">Approve with
                            Payment</button>
                        <button type="submit" class="btn btn-primary" data-approve-type="withoutPayment">Approve
                            without Payment</button>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
    </section>
@endsection

@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>

    <script>
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {}, true);
        });
    </script>

    {{-- <script>
      $('#approveModal').on('hidden.bs.modal', function() {
            $('.modal-backdrop').remove();
        });
    <script> --}}
    
    <script src="https://www.paypalobjects.com/api/checkout.js"></script>
    <script>
      paypal.Button.render({
        env: 'sandbox',
        style: {
         size: 'responsive',
         color: 'gold',
         shape: 'rect',
         label: 'checkout',
         tagline: 'true'
        } ,
    // Or 'production'
        // Set up the payment:
        // 1. Add a payment callback
        payment: function(data, actions) {
          // 2. Make a request to your server
          return actions.request.post('{{route("user.payment.create_payment")}}',{
            "_token": "{{ csrf_token() }}",
            "order_id": "1",
          })
            .then(function(res) {
              // 3. Return res.id from the response
              return res.id;
            });
        },
        // Execute the payment:
        // 1. Add an onAuthorize callback
        onAuthorize: function(data, actions) {
        // 2. Make a request to your server
        console.log(data, actions);
          return actions.request.post('{{route("user.payment.order_success_update")}}', {
                    paymentID: data.paymentID,
                    payerID:   data.payerID,
                    "_token": "{{ csrf_token() }}",
                    "order_id": "1",
                    "order_data": JSON.stringify(data)
              })
            .then(function(res) {
                window.location.href = data.returnUrl;
              // 3. Show the buyer a confirmation message.
            });
        }
      }, '#paypal-button');
    </script>
@endsection