
<?php $__env->startSection('page-css'); ?>
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2><?php echo e($title); ?></h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- Basic Examples -->
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="text-right">
                            <a href="<?php echo e(route('user.invoice.all')); ?>" class="btn btn-primary text-white">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                        </div>
                        <div class="body">
                            <div class="table-responsive">
                                <table id="course-table"
                                    class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Student Name</th>
                                            <th>Date Of Birth</th>
                                            <th>Course Name</th>
                                            <th>Marks</th>
                                            <th>Status</th>
                                            <th>Certification Number</th>
                                            <th>Certificate</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($student->name); ?></td>
                                                <td><?php echo e($student->date_of_birth); ?></td>
                                                <td><?php echo e($student->Course->course_name); ?></td>
                                                <td><?php echo e($student->marks); ?></td>
                                                <td><?php echo e($student->status); ?></td>
                                                <td><?php echo e($student->certification_number); ?></td>
                                                <td>
                                                    <?php if($student->status == 'pass'): ?>
                                                    <button type="button" class="btn btn-primary btn-sm">
                                                        <a href="<?php echo e(route('user.invoice.certificate', $student->id)); ?>" class="text-white">Download &nbsp;<i class="fas fa-download"></i></a>
                                                    </button>
                                                    <?php else: ?>
                                                    <button type="button" class="btn btn-primary btn-sm" hidden>
                                                        <a href="#" class="text-white">Download &nbsp;<i class="fas fa-download"></i></a>
                                                    </button>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                <?php if($student->marks == ''): ?>    
                                                    <button type="button" class="btn btn-primary btn-sm"
                                                            data-toggle="modal" data-target="#invoiceModal"
                                                            data-id="<?php echo e($student->id); ?>">
                                                        <i class="fas fa-cog"></i>
                                                    </button>
                                                <?php else: ?>
                                                    -
                                                <?php endif; ?>    
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="modal fade" id="invoiceModal" tabindex="-1" role="dialog" aria-labelledby="invoiceModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="partnerModalLabel">Marks</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form id="invoiceForm" method="POST" action="<?php echo e(route('user.invoice.save')); ?>">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="student_id" id="student_id">
                            <div class="form-group">
                                <label for=""><strong>Marks</strong></label>
                                <input type="text" class="form-control" name="marks" placeholder="Enter Marks" required>
                            </div>
                            <div class="d-flex justify-content-end mt-3">
                                <button class="btn btn-primary form-submit-btn" type="submit">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <!-- Jquery DataTable Plugin Js -->
    <script src="<?php echo e(asset('front')); ?>/assets/bundles/datatablescripts.bundle.js"></script>
        <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
        <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
        <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
        <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
        <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
        <script src="<?php echo e(asset('front')); ?>/assets/js/pages/tables/jquery-datatable.js"></script>
   
    <script>
        $('#invoiceModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            var studentId = button.data('id'); 
            
            var modal = $(this);
            modal.find('#student_id').val(studentId);
        });
    </script>
    <script>
        $('#invoiceForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var formData = new FormData(this);
            my_ajax(url, formData, 'post', function(res) {

            }, true);
        });
    </script>
    <script>
        $('#invoiceModal').on('hidden.bs.modal', function() {
            $('.modal-backdrop').remove();
        });
        $('#invoiceModal').on('hidden.bs.modal', function() {
            $('.modal-backdrop').remove();
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function removeBackdrop() {
                var backdrops = document.querySelectorAll('.modal-backdrop.fade.show');
                backdrops.forEach(function(backdrop) {
                    backdrop.remove();
                });
            }
            removeBackdrop();

            const observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.addedNodes.length) {
                        removeBackdrop();
                    }
                });
            });
            observer.observe(document.body, {
                childList: true,
                subtree: true
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\oshta\resources\views/client/partner_invoice/view_invoice.blade.php ENDPATH**/ ?>