<?php

namespace App\Console\Commands;

use App\Models\Ads;
use App\Models\DailyAdsSpent;
use App\Models\Transections;
use App\Models\User;
use App\Services\GoogleAdsService;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class CheckDailyAdsSpent extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'daily-ads-spents:check';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $googleAdsService = new GoogleAdsService();
        $today = Carbon::today();
        $date = $today->format('Y-m-d');
        
        // Check all running ads
        $ads = Ads::where('status', 'running')->get();
        foreach ($ads as $ad) {
            $customerId = $ad->client->customer_id;

            // Check campaign spent
            $campaign = $googleAdsService->getCampaignByResourceName($customerId, $ad->google_ad->campaign_resource_name);
            $lastSpendAmount = $ad->spend_amount ?? 0;
            $newSpent = (int) $campaign['metrics']['costMicros'] - $lastSpendAmount;

            // Campaign spent updated
            if ($newSpent > 0) {
                DB::beginTransaction();
                try {
                    // Save daily ads spent record
                    DailyAdsSpent::create([
                        'sub_account_id' => $ad->client->sub_account_id,
                        'amount' => $newSpent,
                        'date' => $date,
                        'added_by_id' => 1,
                    ]);

                    // Save transaction
                    $lastTansaction = Transections::where('client_id', $ad->client->id)->orderBy('created_at', 'desc')->first();
                    $lastBalance = $lastTansaction ? $lastTansaction->available_balance : 0;
                    $currentBalance = $lastBalance - $newSpent;
                    
                    Transections::create([
                        'sub_account_id' => $ad->client->id,
                        'amount_out' => $newSpent,
                        'available_balance' => $currentBalance,
                        'ads_id' => $ad->id,
                    ]);
    
                    // Stop the campaign when the Wallet Balance is equal or less then 50$
                    if ($currentBalance <= 50) {
                        $ad->status = 'pause';
                        $ad->save();
                    }
                    DB::commit();
                } catch (\Exception $e) {
                    DB::rollback();
                }
            }
        }

        return Command::SUCCESS;
    }
}
