<?php

namespace App\Http\Controllers\Administrator;

use App\Http\Controllers\Controller;
use App\Models\CardExam;
use App\Models\CardExamQuestion;
use App\Models\Cards;
use App\Models\QuestionOption;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ExamController extends Controller
{
    public function add_exam()
    {
         $cards = Cards::leftJoin('card_exams', 'cards.id', '=', 'card_exams.card_id')
              ->whereNull('card_exams.card_id')
              ->select('cards.*')
              ->get();
              
        $data = array(
            'title' => 'Add Exam',
            'sub_title' => 'Add Exam',
            'sidebar_menu' => 'add_exam',
            'cards' => $cards
        );
        return view('admin.exam.add_exam')->with($data);
    }
    public function save(Request $request)
    { 
        $customMessages = [
            'card_id.required' => 'Card field is required.', 
            'question.required' => 'Question is required.',
            'question.array' => 'The questions field must be an array.',
            'question.*.question.required' => 'The question field is required for all questions.',
            'question.*.correct_answer.required' => 'The correct answer field is required for all questions.',
            'question.*.option_1.required' => 'Option 1 is required for all questions.',
            'question.*.option_2.required' => 'Option 2 is required for all questions.',
            'question.*.option_3.required' => 'Option 3 is required for all questions.',
            'question.*.option_4.required' => 'Option 4 is required for all questions.',
        ];

        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'card_id' => 'required', 
            'question' => 'required',
            'question.*.question' => 'required|string|max:255',
            'question.*.correct_answer' => 'required|numeric',
            'question.*.option_1' => 'required',
            'question.*.option_2' => 'required',
            'question.*.option_3' => 'required',
            'question.*.option_4' => 'required',
        ], $customMessages);


        if ($validator->fails()) {
            return ['errors' => $validator->errors()];
        }

        $CardExam = new CardExam();
        if (!empty($request->id)) {
            
            
            $CardExam = $CardExam->with('CardExamQuestion.QuestionOptions')->find($request->id);
            $msg = [
                'success' => 'Exam Updated Successfully',
                'redirect' => route('admin.exam.card')
            ];
        } else {
            $msg = [
                'success' => 'Exam Created Successfully',
                'redirect' => route('admin.exam.card')
            ];
        }

        $CardExam->card_id = $request->card_id;
        $CardExam->title = $request->title;
        $CardExam->save();

        if (!empty($request->id)) {
            $CardExam->CardExamQuestion->each(function ($CardExamQuestion) {
                $CardExamQuestion->QuestionOptions->each(function ($QuestionOptions) {
                    $QuestionOptions->delete();
                });
                $CardExamQuestion->delete();
            });
        }

        foreach ($request->question as $key => $value) {
            $CardExamQuestion = new CardExamQuestion();
            $CardExamQuestion->card_exam_id = $CardExam->id;
            $CardExamQuestion->question = $value['question'];
            $CardExamQuestion->correct_answer_number = $value['correct_answer'];
            $CardExamQuestion->correct_answer = $value['option_' . $value['correct_answer']];

            $CardExamQuestion->save();

            $options = [
                [
                    'question_id' => $CardExamQuestion->id,
                    'option' => $value['option_1'],
                ],
                [
                    'question_id' => $CardExamQuestion->id,
                    'option' => $value['option_2'],
                ],
                [
                    'question_id' => $CardExamQuestion->id,
                    'option' => $value['option_3'],
                ],
                [
                    'question_id' => $CardExamQuestion->id,
                    'option' => $value['option_4'],
                ]
            ];

            QuestionOption::insert($options);
        }

        return response()->json($msg);
    }

    function edit($id)
    {
        $data = [
            'title' => 'Edit Exam',
            'cards' => Cards::all(),
            'edit' => CardExam::hashidFind($id),
            'sub_title' => 'Edit Exam',
            'sidebar_menu' => 'add_exam',
            'edit' => CardExam::with('CardExamQuestion.QuestionOptions')->hashidFind($id)
        ];
        return view('admin.exam.add_exam', $data);
    }
    public function exam_card()
    {
        $data = array(
            'title' => 'Exam Card',
            'sub_title' => 'Exam Card',
            'sidebar_menu' => 'add_exam',
            'cards' => CardExam::with('card')->withCount('questions')->get()
        );

        return view('admin.exam.exam_card')->with($data);
    }
    public function delete($id)
    {
        $exam = CardExam::hashidFind($id);

        if ($exam) {
            $exam->delete();

            return response()->json([
                'success' => 'Exam deleted successfully.',
                'reload' => true,
            ]);
        } else {
            return response()->json([
                'success' => 'Exam not found.',
                'reload' => true,
            ], 404);
        }
    }
}
