<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\LeadClient;
use App\Models\LeadData;
use App\Models\Ads;
use App\Models\AdsInvoice;
use App\Models\client_message_template;
use App\Models\SubAccount;
use App\Models\User;
use App\Models\JunkLead;
use App\Models\DailyAdsSpent;
use App\Models\TaxCharge;
use App\Models\Transections;
use App\Traits\AdsSpentTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Traits\GoogleTrait;
use Carbon\Carbon;
use App\Models\WpMessageTemplate;

class FetchLeadsController extends Controller
{
    use GoogleTrait, AdsSpentTrait;

    function get_lead_form_website(Request $request, $que_lead = null){
        if ($que_lead == null) {
            $referer = $this->extractBaseUrlPattern($request->source_url);
            $username = $request->header('PHP_AUTH_USER');
            $password = $request->header('PHP_AUTH_PW');
            if ($username !== 'Client Management Portal' || $password !== '123456') {
                return response()->json(['error' => 'Unauthorized'], 401);
            }
        } else {

            $request = json_decode($que_lead->lead_data);
            $referer = $this->extractBaseUrlPattern($que_lead->sub_account_url);
        }

        $check_referer_exist = Ads::where('website_url', $referer)->where('status', 'running')->first();
        if ($check_referer_exist) { 
            
            $check_email_exist = LeadClient::where('client_id', $check_referer_exist->client_id)
            ->where('ads_id',$check_referer_exist->id)
            ->where('email', $request->email)
            ->orWhere('mobile_number', $request->mobile_number)
            ->count();
            // dd($check_email_exist);
            if ($check_email_exist > 0) {
                $junk_lead = new JunkLead;
                if ($que_lead == null) {
                    $junk_lead->lead_data = json_encode($request->all());
                    $junk_lead->sub_account_id = $check_referer_exist->id ?? "";
                    $junk_lead->sub_account_url = $request->source_url ?? "";
                } else {
                    $junk_lead->lead_data = $que_lead->lead_data;
                    $upd_status = JunkLead::find($que_lead->id);
                    $upd_status->is_send = 1;
                    $upd_status->update();
                }
                $junk_lead->save();

                DB::commit();

                return response()->json([
                    'success' => true,
                    'msg' => 'This Is Junk Lead Save Successfully'
                ]);
            }else{
                if ($que_lead == null) {
                    $leads = $request->all();
                } else {
                    $leads = $request;
                }

                if (!empty($check_referer_exist) && !empty($leads)) {
                    $ads_lead = new LeadClient();
                    if ($request->status == 'DNC Registry') {
                        $ads_lead->client_id = 0;
                        $ads_lead->status = 'DNC Registry';
                    } else {
                        $ads_lead->client_id = $check_referer_exist->client_id;
                        $ads_lead->ads_id = $check_referer_exist->id;
                    }
                    $ads_lead->name = $request->name ?? '';
                    $ads_lead->email = $request->email ?? '';
                    $ads_lead->mobile_number = $request->mobile_number ?? '';
                    $ads_lead->lead_type = 'ppc';
                    $ads_lead->added_by_id = $check_referer_exist->client_id;
                    $ads_lead->save();

                    $lead_key_data = [];
                    if (!empty($request->additional_data) && count($request->additional_data) > 0) {
                        foreach ($request->additional_data as $k => $val) {

                            if (is_array($val)) {
                                $lead_key_data[] = [
                                    'lead_client_id' => $ads_lead->id,
                                    'key' => $val['key'],
                                    'value' => $val['value'],
                                    'added_by_id' => $ads_lead->client_id,
                                    'created_at' => now(),
                                    'updated_at' => now(),
                                ];
                            } else {
                                $lead_key_data[] = [
                                    'lead_client_id' => $ads_lead->id,
                                    'key' => $val->key,
                                    'value' => $val->value,
                                    'added_by_id' => $ads_lead->client_id,
                                    'created_at' => now(),
                                    'updated_at' => now(),
                                ];
                            }
                        }
                        LeadData::insert($lead_key_data);
                    }

                    if ($que_lead != null) {
                        $upd_status = JunkLead::find($que_lead->id);
                        $upd_status->is_send = 1;
                        $upd_status->update();
                    }

                    if (isset($ads_lead->email) && !empty($ads_lead->email)) {
$leadMessage = "New Lead Please take note!
===========================
Hello " . $check_referer_exist->client->client_name . ", you have a new lead:
- Name: {$ads_lead->name}
- Email: {$ads_lead->email}
- Mobile Number: https://wa.me/+65{$ads_lead->mobile_number}";
                    } else {
                        $leadMessage = "New Lead Please take note!
===========================
Hello " . $check_referer_exist->client->client_name . ", you have a new lead:
- Name: {$ads_lead->name}
- Mobile Number: https://wa.me/+65{$ads_lead->mobile_number}";
                    }
                    
                    
                    if (!empty($request->additional_data) && count($request->additional_data) > 0) {
                        foreach ($request->additional_data as $val) {
                            if (is_array($val)) {
                                $leadMessage .= "\n- {$val['key']}: {$val['value']}";
                            } else {
                                $leadMessage .= "\n- {$val->key}: {$val->value}";
                            }
                        }
                    }

                    $url = $check_referer_exist->discord_link;
                    if ($request->status != 'DNC Registry') {
                        $send_descord_msg = $this->send_discord_msg($url, $leadMessage);
                    }
                    if (empty($send_descord_msg)) {
                        $ads_lead->is_send_discord = 1;
                    } else {
                        $ads_lead->is_send_discord = 0;
                    }
                    $ads_lead->save();
                }

                DB::commit();

                $response = $this->verifySalesperson($request->mobile_number);
                if (@$response->result) {
                    $ads_lead->user_status = "agent";
                    $ads_lead->registration_no = $response->data->reg_number;
                    $ads_lead->save();
                }

                return response()->json([
                    'success' => true,
                    'msg' => 'Lead Send Successfully'
                ]);
            }
       
        } else {
            $junk_lead = new JunkLead;
            $junk_lead->lead_data = json_encode($request);
            $junk_lead->status = "que_lead";
            $junk_lead->sub_account_url = $request->source_url ?? "";
            $junk_lead->save();

            return response()->json([
                'success' => true,
                'msg' => 'No Sub Account Match! Lead Save In a Que'
            ]);
        }
    }


    function add_ppc_lead(Request $request, $que_lead = null)
    { 
        if ($que_lead == null) {
            $referer = $this->extractBaseUrlPattern($request->source_url);
            $username = $request->header('PHP_AUTH_USER');
            $password = $request->header('PHP_AUTH_PW');
            if ($username !== 'Client Management Portal' || $password !== '123456') {
                return response()->json(['error' => 'Unauthorized'], 401);
            }
        } else {

            $request = json_decode($que_lead->lead_data);
            $referer = $this->extractBaseUrlPattern($que_lead->sub_account_url);
        }

        $check_referer_exist = SubAccount::where('sub_account_url', $referer)->where('status', 'Active')->first();


        if ($check_referer_exist) {
            $user_ids = User::where('sub_account_id', $check_referer_exist->id)->pluck('id');
        } else {
            $junk_lead = new JunkLead;
            $junk_lead->lead_data = json_encode($request);
            $junk_lead->status = "que_lead";
            $junk_lead->sub_account_url = $request->source_url ?? "";
            $junk_lead->save();

            return response()->json([
                'success' => true,
                'msg' => 'No Sub Account Match! Lead Save In a Que'
            ]);
        }


        try {
            $adsList = $this->findRunningAds($user_ids, $check_referer_exist->id);

            if (!isset($adsList->client_id)) {
                $junk_lead = new JunkLead;
                $junk_lead->lead_data = json_encode($request->all());
                $junk_lead->status = "que_lead";
                $junk_lead->sub_account_id = $check_referer_exist->id ?? "";
                $junk_lead->sub_account_url = $request->source_url ?? "";
                $junk_lead->save();
                return $adsList;
            }

            DB::beginTransaction();

            $check_email_exist = LeadClient::whereIn('client_id', $user_ids)
                ->where(function ($query) use ($request) {
                    $query->where('email', $request->email)
                        ->orWhere('mobile_number', $request->mobile_number);
                })
                ->count();

            if ($check_email_exist > 0) {
                $junk_lead = new JunkLead;
                if ($que_lead == null) {
                    $junk_lead->lead_data = json_encode($request->all());
                    $junk_lead->sub_account_id = $check_referer_exist->id ?? "";
                    $junk_lead->sub_account_url = $request->source_url ?? "";
                } else {
                    $junk_lead->lead_data = $que_lead->lead_data;
                    $upd_status = JunkLead::find($que_lead->id);
                    $upd_status->is_send = 1;
                    $upd_status->update();
                }
                $junk_lead->save();

                DB::commit();

                return response()->json([
                    'success' => true,
                    'msg' => 'This Is Junk Lead Save Successfully'
                ]);
            } 
            else {
                if ($que_lead == null) {
                    $leads = $request->all();
                } else {
                    $leads = $request;
                }

                if (!empty($adsList) && !empty($leads)) {
                    $ads_lead = new LeadClient();
                    if ($request->status == 'DNC Registry') {
                        $ads_lead->client_id = 0;
                        $ads_lead->status = 'DNC Registry';
                    } else {
                        $ads_lead->client_id = $adsList->client_id;
                    }
                    $ads_lead->name = $request->name ?? '';
                    $ads_lead->email = $request->email ?? '';
                    $ads_lead->mobile_number = $request->mobile_number ?? '';
                    $ads_lead->lead_type = 'ppc';
                    $ads_lead->added_by_id = $adsList->client_id;
                    $ads_lead->save();

                    $sheet_name = 'Leads Frequency';
                    $find_user = User::find($adsList->client_id);
                    $spreadsheet_id = $find_user->spreadsheet_id;
                    if (!empty($spreadsheet_id) && $request->status != 'DNC Registry') {
                        if (isset($request->email) && !empty($request->email)) {
                            $this->saveToGoogleSheet($request->name, $request->email, $request->mobile_number, $request->additional_data, $sheet_name, $spreadsheet_id);
                        } else {
                            $this->saveToGoogleSheet($request->name, $request->email ?? "", $request->mobile_number, $request->additional_data, $sheet_name, $spreadsheet_id);
                        }
                    }

                    $lead_key_data = [];

                    if (!empty($request->additional_data) && count($request->additional_data) > 0) {
                        foreach ($request->additional_data as $k => $val) {

                            if (is_array($val)) {
                                $lead_key_data[] = [
                                    'lead_client_id' => $ads_lead->id,
                                    'key' => $val['key'],
                                    'value' => $val['value'],
                                    'added_by_id' => $ads_lead->client_id,
                                    'created_at' => now(),
                                    'updated_at' => now(),
                                ];
                            } else {
                                $lead_key_data[] = [
                                    'lead_client_id' => $ads_lead->id,
                                    'key' => $val->key,
                                    'value' => $val->value,
                                    'added_by_id' => $ads_lead->client_id,
                                    'created_at' => now(),
                                    'updated_at' => now(),
                                ];
                            }
                        }
                        LeadData::insert($lead_key_data);
                    }

                    if ($que_lead != null) {
                        $upd_status = JunkLead::find($que_lead->id);
                        $upd_status->is_send = 1;
                        $upd_status->update();
                    }

                    if (isset($ads_lead->email) && !empty($ads_lead->email)) {
                        $leadMessage = "New Lead Please take note!
===========================
Hello " . $adsList->client->client_name . ", you have a new lead:
- Name: {$ads_lead->name}
- Email: {$ads_lead->email}
- Mobile Number: https://wa.me/+65{$ads_lead->mobile_number}";
                    } else {
                        $leadMessage = "New Lead Please take note!
===========================
Hello " . $adsList->client->client_name . ", you have a new lead:
- Name: {$ads_lead->name}
- Mobile Number: https://wa.me/+65{$ads_lead->mobile_number}";
                    }

                    if (!empty($request->additional_data) && count($request->additional_data) > 0) {
                        foreach ($request->additional_data as $val) {
                            if (is_array($val)) {
                                $leadMessage .= "\n- {$val['key']}: {$val['value']}";
                            } else {
                                $leadMessage .= "\n- {$val->key}: {$val->value}";
                            }
                        }
                    }

                    $url = $adsList->discord_link;
                    if ($request->status != 'DNC Registry') {
                        $send_descord_msg = $this->send_discord_msg($url, $leadMessage);
                    }

                    if (empty($send_descord_msg)) {
                        $ads_lead->is_send_discord = 1;
                    } else {
                        $ads_lead->is_send_discord = 0;
                    }
                    $ads_lead->save();

                    $check_msg_status = WpMessageTemplate::first();
                    //whatsapp msg send code
                    if ($check_msg_status->status === 'active'){

                        if($request->status != 'DNC Registry'){
                            if ($request->mobile_number && !empty($request->mobile_number)) {
                                    $get_message = client_message_template::where('client_id',$adsList->client_id)->first();
                                if ($get_message) {
                                    $replece_name = str_replace('@clientName',$ads_lead->name,$get_message->message_template);
                                    $replece_email = str_replace('@email',$ads_lead->email,$replece_name);
                                    $replece_phone = str_replace('@phone',$ads_lead->mobile_number,$replece_email);

                                    $send_message = $this->send_wp_message($request->mobile_number, $replece_phone);
                                } else {
                                    $get_message = WpMessageTemplate::first();
                                    $replece_name = str_replace('@clientName',$ads_lead->name,$get_message->wp_message);
                                    $replece_email = str_replace('@email',$ads_lead->email,$replece_name);
                                    $replece_phone = str_replace('@phone',$ads_lead->mobile_number,$replece_email);

                                    $send_message = $this->send_wp_message($request->mobile_number, $replece_phone);

                                }
                            }
                        }
                    }

                    //whatsapp msg send code
                    $adsList->lead_status = 1;
                    $adsList->save();
                }

                DB::commit();

                $response = $this->verifySalesperson($request->mobile_number);
                if (@$response->result) {
                    $ads_lead->user_status = "agent";
                    $ads_lead->registration_no = $response->data->reg_number;
                    $ads_lead->save();
                }

                return response()->json([
                    'success' => true,
                    'msg' => 'Lead Send Successfully'
                ]);
            }
        } catch (\Exception $e) {
            // Something went wrong, rollback the transaction
            DB::rollback();

            // Access the error message
            $errorMessage = $e->getMessage();

            // You can log or handle the error message as needed
            // For example, you can throw a custom exception with a more specific message
            throw new \Exception("Error receiving lead: $errorMessage");
        }
    }

    function week_payment()
    {
        $get_sub_accounts = SubAccount::get();

        foreach ($get_sub_accounts as $sub_account) {
            $users = User::where('sub_account_id', $sub_account->id)->get();

            foreach ($users as $user) {
                $ads = Ads::where('client_id', $user->id)->whereIn('status', ['running', 'pause'])->get();

                foreach ($ads as $ad) {

                    $this_weak_payment = $this->client_payment($ad->client_id, $sub_account->id);
                    if ($this_weak_payment <= 0) {
                        continue;
                    }

                    $dates = $this->get_user_start_end_time($ad->client_id);
                    $weekStartDate = $dates['start_date']->format('Y-m-d H:i:s');
                    $weekEndDate = $dates['end_date']->format('Y-m-d H:i:s');

                    $trans = Transections::where('client_id', $ad->client_id);
                    $remaining_amount = ($trans->sum('amount_in') - $trans->sum('amount_out'));
                    $available_balance = $remaining_amount - $this_weak_payment;

                    $add_transaction = new Transections;
                    $add_transaction->available_balance = $available_balance;
                    $add_transaction->client_id = $ad->client_id;
                    $add_transaction->amount_out = $this_weak_payment;
                    $add_transaction->ads_id = $ad->id;
                    $add_transaction->save();
                    if ($available_balance <= 50) {
                        $ads = Ads::find($ad->id);
                        $ads->status = 'pause';
                        $ads->spend_amount = ($ads->spend_amount + $this_weak_payment);
                        $ads->save();
                    }

                    $dates = $this->get_user_start_end_time($ad->client_id);
                    $weekStartDate = $dates['start_date']->format('Y-m-d');
                    $weekEndDate = $dates['end_date']->format('Y-m-d');

                    $ads_invoice = new AdsInvoice;
                    $ads_invoice->client_id = $ad->client_id;
                    $ads_invoice->invoice_date =  date('Y-m-d');
                    $ads_invoice->gst =  ($this_weak_payment * (9 / 100));
                    $ads_invoice->total_amount = $this_weak_payment;
                    $ads_invoice->total_lead = $this->this_week_client_leads($ad->client_id);
                    $ads_invoice->start_date = $weekStartDate;
                    $ads_invoice->end_date = $weekEndDate;
                    $ads_invoice->save();
                }
            }
        }
    }

    private function findRunningAds($user_ids, $get_sub_account_id)
    {
        // Check if there are any running ads
        $ids = $user_ids;
        $sub_account_id = $get_sub_account_id;
        $runningAdsCount = Ads::where('status', 'running')->whereIn('client_id', $ids)->count();
        if ($runningAdsCount == 0) {
            return response()->json([
                'success' => true,
                'msg' => 'Running Ads Not Found! Que Lead Save Successfully'
            ]);
        }

        // Find the first running ad with lead_status '0'
        $adsList = Ads::where('status', 'running')->whereIn('client_id', $ids)->where('lead_status', '0')->latest()->first(['id', 'client_id', 'lead_status', 'discord_link']);

        // If no ads found with lead_status '0', update all running ads to have lead_status '0' and retry
        if (empty($adsList)) {
            Ads::where('status', 'running')->whereIn('client_id', $ids)->update(['lead_status' => 0]);
            return $this->findRunningAds($ids, $sub_account_id);
            // Recursively call the function to retry finding ads
        }

        $this_weak_payment = $this->client_payment($adsList->client_id, $sub_account_id);

        $trans = Transections::where('client_id', $adsList->client_id);

        $remaining_amount = ($trans->sum('amount_in') - $trans->sum('amount_out'));

        $available_balance = $remaining_amount - $this_weak_payment;

        if ($available_balance <= 50) {
            $ads = Ads::find($adsList->id);
            $ads->status = 'pause';
            $ads->lead_status = 0;
            $ads->save();

            return $this->findRunningAds($ids, $sub_account_id);
        }

        return $adsList;
    }


    function send_client_leads_on_discord($leads_start_time)
    {

        $get_leads = LeadClient::with('lead_data', 'clients')
            ->where('lead_type', 'ppc')->where('is_send_discord', '0')
            ->where('created_at', '>', $leads_start_time)
            ->limit(15)->get();

        if ($get_leads->count() > 0) {
            foreach ($get_leads as $key => $lead) {

                $get_discord_link = Ads::where('client_id', $lead->client_id)->latest()->first(['discord_link']);

                $leadMessage = "New Lead Please take note!
===========================
Hello " . $lead->clients->client_name . ", you have a new lead:
- Name: {$lead->name}
- Email: {$lead->email}
- Mobile Number: https://wa.me/+65{$lead->mobile_number}";

                if (!empty($lead->lead_data) && count($lead->lead_data) > 0) {
                    foreach ($lead->lead_data as $val) {
                        $leadMessage .= "\n- {$val['key']}: {$val['value']}";
                    }
                }

                $url = $get_discord_link->discord_link;
                $send_discord_msg = $this->send_discord_msg($url, $leadMessage);

                if (empty($send_discord_msg)) {
                    $lead->is_send_discord = 1;
                } else {
                    $lead->is_send_discord = 0;
                }
                $lead->save();
            }
        } else {
            return response()->json(['error' => 'No leads found.'],  422);
        }
    }




    public function send_que_leads()
    {

        $check_running_ads = Ads::where('status', 'running')->count();
        if ($check_running_ads == 0) {
            return response()->json([
                'success' => false,
                'message' => "There Is No Running Ads."
            ]);
        } else {
            $get_que_lead = JunkLead::where('status', 'que_lead')->where('is_send', '0')->first();
            if ($get_que_lead) {
                $request = new Request();
                $send_que_lead = $this->add_ppc_lead($request, $get_que_lead);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => "There Is No Leads In Que."
                ]);
            }
        }
    }

    private function send_discord_msg($url, $data)
    {
        $post_array = array(
            'content' => $data,
            'embeds' => null,
            'attachments' => []
        );
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($post_array),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Cookie: __dcfduid=8ec71370974011ed9aeb96cee56fe4d4; __sdcfduid=8ec71370974011ed9aeb96cee56fe4d49deabe12bc0fc3d686d23eaa0b49af957ffe68eadec722cff5170d5c750b00ea'
            ),
            CURLOPT_SSL_VERIFYPEER => false
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        return $response;
    }

    private function extractBaseUrlPattern($url)
    {
        $parsedUrl = parse_url($url);
        return $parsedUrl['scheme'] . '://' . $parsedUrl['host'] . '/';
    }

    private function send_wp_message($client_number, $message)
    {
        die();
        $curl = curl_init();
        $api_key = config('app.wp_api_key');
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.p.2chat.io/open/whatsapp/send-message',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode(array(
                "to_number" => $client_number,
                "from_number" => "+6589469107",
                "text" => $message
            )),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'X-User-API-Key: ' . $api_key
            ),
        ));

        $response = curl_exec($curl);

        if (curl_errno($curl)) {
            echo 'Curl error: ' . curl_error($curl);
        }

        curl_close($curl);
        return $response;
    }


    public function add_message_to_user(Request $request)
    {

        $get_clients = User::all();

        $get_message = client_message_template::first();

        if ($get_message) {
            $data = [];

            foreach ($get_clients as $client) {
                $data[] = [
                    'client_id' => $client->id,
                    'message_template' => $get_message->message_template,
                    'created_at' => now(),
                    'updated_at' => now(),
                ];
            }

            client_message_template::insert($data);

            return response()->json(['message' => 'Messages assigned to all users successfully.']);
        } else {
            return response()->json(['message' => 'No message template found.'], 404);
        }
    }


    private function verifySalesperson($mobileNumber)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.jomejourney-portal.com/api/verify-salesperson',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
            "phone":"' . $mobileNumber . '"
        }',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return json_decode($response);
    }


    public function assign_template_to_clients()
    {

        $adminTemplate = WpMessageTemplate::latest()->first();

        if (!$adminTemplate) {
            return response()->json(['error' => 'No admin message template found'], 404);
        }

        $clients = User::all();

        if ($clients->isEmpty()) {
            return response()->json(['error' => 'No clients found'], 404);
        }

        client_message_template::truncate();

        $clientTemplates = [];
        foreach ($clients as $client) {
            $clientTemplates[] = [
                'client_id' => $client->id,
                'message_template' => $adminTemplate->wp_message,
                'from_number' => $adminTemplate->from_number,
                'created_at' => now(),
                'updated_at' => now(),
            ];
        }
        $client_message_template = client_message_template::insert($clientTemplates);
        if ($client_message_template) {
            return response()->json(['message' => 'Messages assigned to all users successfully.']);
        } else {
            return response()->json(['error' => 'Failed to assign admin message template: '], 500);
        }
    }
}
