<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\Course;
use App\Models\PartnerInvoice;
use App\Models\StudentRegistration;
use Illuminate\Http\Request;
use App\Mail\InvoiceEmail;
use Illuminate\Support\Facades\Mail;

class StudentController extends Controller
{
    public function add_student()
    {  
        $courses = Course::all();
        $data = [
            'title' => 'Register Student',
            'sidebar_menu' => 'student_registration',
            'courses' => $courses
        ];

        return view('client.student.add_student')->with($data);
    }
    public function add_course_fee(Request $request)
    {
        $course_name = $request->input('course_name');
        $course_price = Course::where('course_name', $course_name)->pluck('course_price');
        return response()->json($course_price);
    }
    public function store(Request $request)
    {
        $auth_id = auth('web')->id();
        do {
            $prefix = 'osh';
            $uniqueNumber = str_pad(mt_rand(1, 999999), 6, '0', STR_PAD_LEFT);
            $invoiceNumber = $prefix . $uniqueNumber;
        } while (PartnerInvoice::where('invoice_number', $invoiceNumber)->exists());

        $totalCoursePrice = 0;
        // Prepare the data for insertion and calculate the total course price
        $preparedData = [];
        for ($i = 0; $i < count($request->name); $i++) {
            $coursePrice = $request->course_price[$i];
            $totalCoursePrice += $coursePrice;
        }
        $invoice = PartnerInvoice::create([
            'partner_id' => $auth_id,
            'invoice_number' => $invoiceNumber,
            'invoice_price' => $totalCoursePrice
        ]);
        // Get the generated invoice ID
        $invoiceId = $invoice->id;
        // Prepare the student registration data
        for ($i = 0; $i < count($request->name); $i++) {
            $preparedData[] = [
                'name' => $request->name[$i],
                'date_of_birth' => $request->date_of_birth[$i],
                'course_id' => $request->course_name[$i],
                'course_price' => $request->course_price[$i],
                'invoice_id' => $invoiceId
            ];
        }
        $auth_id = auth('web')->user();
        $partner = StudentRegistration::insert($preparedData);

        $data = array(
            'course_name' => Course::whereIn('id',$request->course_name)->get(),
            'totalCoursePrice' => $totalCoursePrice
        );

        Mail::to($auth_id->email)->send(new InvoiceEmail($data));

        $msg = [
            'success' => 'Student Registered successfully',
            'redirect' => route('user.student.add_student'),
        ];
        return response()->json($msg);
    }

    
    
}
