<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use App\Models\PartnerInvoice;
use App\Models\StudentRegistration;
use Illuminate\Http\Request;

class StudentResultController extends Controller
{
    public function view_result()
{
    $auth_id = auth('web')->id();

    // Fetch invoices related to the logged-in user
    $invoices = PartnerInvoice::where('partner_id', $auth_id)->where('payment_status','paid')->get();

    // Fetch student registrations associated with these invoices
    $students = StudentRegistration::whereIn('invoice_id', $invoices->pluck('id'))->get();

    $data = [
        'title' => 'View Student Result',
        'sidebar_menu' => 'result',
        'students' => $students,
    ];

    return view('client.result.view_result')->with($data);
}
}
