<?php



namespace App\Http\Controllers\Frontend;



use App\Http\Controllers\Controller;
use App\Models\CardExam;
use App\Models\Cards;
use App\Models\User;
use App\Models\UserCard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\UserTest;
use App\Models\UserTestQuestion;
use App\Models\UserTestQuestionOption;
use Carbon\Carbon;
use Dompdf\Dompdf;
use Dompdf\Options;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use App\Models\PartnerPaymentMethod;


class UserCardsController extends Controller

{

    public function all_cards()

{  

    $user = auth('web')->user();



    $all_cards = Cards::with(['CardCategory', 'userCard', 'exam'])

        ->leftJoin('user_tests', function ($join) use ($user) {

            $join->on('cards.id', '=', 'user_tests.card_id')

                ->where('user_tests.user_id', '=', $user->id)

                ->where('user_tests.result', '>=', 50); 

        })

        ->select('cards.*', 'user_tests.result as test_result')

        ->groupBy('cards.id')

        ->latest()

        ->get();



    $data = array(

        'title' => 'All Cards',

        'sub_title' => 'All cards',

        'sidebar_menu' => 'all_cards',

        'all_data' => $all_cards,

    );



    return view('client.user_cards.all_cards')->with($data);

}



    public function buyCard($id)
    {    
        $user = auth('web')->user();
        $cardId = $id;
        
        $card = Cards::findOrFail($cardId);
       
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();
        $response = $provider->createOrder([
            "intent" => "CAPTURE",
            "application_context" => [
                "return_url" => route('user.cards.pay_success'), // Pass the ID to success URL
                "cancel_url" => route('user.cards.pay_cancel')  // Pass the ID to cancel URL
            ],
            "purchase_units" => [
                [
                    "reference_id" => $card->id, // Add the ID in purchase_units for reference
                    "amount" => [
                        "currency_code" => "EUR",
                        "value" => $card->price
                    ]
                ]
            ]
        ]);

        if (isset($response['id']) && $response['id'] != null) {
            foreach ($response['links'] as $link) {
                if ($link['rel'] === 'approve') {
                    return redirect()->away($link['href']); // Redirect to PayPal approval page
                }
            }
        } else {
            return redirect()->route('user.cards.pay_cancel'); // Pass the ID to cancel URL
        }
        
    }

    public function success(Request $request)
    {   
        $user = auth('web')->user(); 
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();
        $response = $provider->capturePaymentOrder($request->token);

        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
           
            // Insert data into database
            $payment = new PartnerPaymentMethod();
            $payment->payment_id = $response['id'];
            $payment->product_name = session()->get('product_name');
            $payment->quantity = session()->get('quantity');
            $payment->amount = $response['purchase_units'][0]['payments']['captures'][0]['amount']['value'];
            $payment->currency = $response['purchase_units'][0]['payments']['captures'][0]['amount']['currency_code'];
            $payment->payer_name = $response['payer']['name']['given_name'];
            $payment->payer_email = $response['payer']['email_address'];
            $payment->payment_status = $response['status'];
            $payment->payment_method = "PayPal";

            // Save the user or transaction ID in the user_id column
            $id = $response['purchase_units'][0]['reference_id'];
            $card_data = Cards::with('exam')->where("id",$id)->latest()->first(); 
            $payment->user_id = $user->id; // Store the transaction ID in user_id

            $payment->save();

            DB::table('user_cards')->insert([
                'user_id' => $user->id,
                'card_id' => $id,
                'card_name' => $card_data->title,
                'exam_name' => $card_data->exam->title,
                'card_price' => $card_data->price,
                'created_at' => now(),
                'updated_at' => now()
            ]);
    

            return redirect()->route('user.cards.all')->with('success', 'Payment completed successfully!');
        } else {
            return redirect()->route('user.cards.all')->with('error', 'Payment was canceled!');
        }
    }

    public function cancel()
    {
        return redirect()->route('user.cards.all')->with('error', 'Payment was canceled!');
    }

    public function my_card()

    {

        $user = auth('web')->user();



        $all_data = UserCard::where('user_cards.user_id', $user->id)

            ->leftJoin('user_tests', function ($join) use ($user) {

                $join->on('user_cards.card_id', '=', 'user_tests.card_id')

                    ->where('user_tests.user_id', '=', $user->id);

            })

            ->select('user_cards.*', 'user_tests.result as test_result')

            ->groupBy('user_cards.card_id')

            ->get();
            
            // dd($all_data);



        $data = array(

            'title' => 'My Cards',

            'sub_title' => 'All cards',

            'sidebar_menu' => 'my_card',

            'all_data' => $all_data,

        );



        return view('client.user_cards.my_cards')->with($data);

    }



    public function save_exam($id)

    {

        $user = auth('web')->user();

        $exam_data = CardExam::with(['CardExamQuestion.QuestionOptions'])->where('card_id', hashids_decode($id))->first();

        $selected_questions = $exam_data->CardExamQuestion->random(50);



        $user_test = new UserTest();

        $user_test->user_id = $user->id;

        $user_test->exam_id = $exam_data->id;

        $user_test->card_id = $exam_data->card_id;

        $user_test->time = $exam_data->time;

        $user_test->save();



        foreach ($selected_questions as $val) {



            $user_test_question = new UserTestQuestion();

            $user_test_question->user_test_id = $user_test->id;

            $user_test_question->question = $val->question;

            $user_test_question->correct_answer = $val->correct_answer;

            $user_test_question->type = $val->type;

            $user_test_question->save();



            foreach ($val->QuestionOptions as $key => $option) {

                $UserTestQuestionOption = new UserTestQuestionOption();

                $UserTestQuestionOption->answer_options = $option->option;

                $UserTestQuestionOption->test_question_id = $user_test_question->id;

                $UserTestQuestionOption->save();

            }

        }



        return redirect()->route('user.cards.exam_start', hashids_encode($user_test->id));

    }

    public function start_exam($id)

    {

        $userTestId = hashids_decode($id);



        $UserTest = UserTest::with('exam')->where('id', $userTestId)->first();



        // $firstQuestion = UserTestQuestion::with('options')->where('user_test_id', $userTestId)->first();

        $firstQuestion = UserTestQuestion::with('options')

            ->where('user_test_id', $userTestId)

            ->where('status', 0)

            ->first();

        $totalQuestions = UserTestQuestion::where('user_test_id', $userTestId)->count();





        $answeredQuestionsCount = UserTestQuestion::where('user_test_id', $userTestId)

            ->where('status', 1)

            ->count();



        $data = array(

            'title' => 'My Exam',

            'sub_title' => 'Exam',

            'sidebar_menu' => 'my_card',

            'text' => $UserTest,

            'firstQuestion' => $firstQuestion,

            'user_test_id' => $userTestId,

            'examName' => $UserTest->exam->title,

            'totalQuestions' => $totalQuestions,

            'answeredQuestionsCount' => $answeredQuestionsCount,

        );



        return view('client.user_cards.exam')->with($data);

    }

    public function attempt_exam(Request $request)

    {

        $user = auth('web')->user();



        $request->validate([

            'question_id' => 'required|integer',

            'user_test_id' => 'required|integer',

        ]);



        $selectedAnswer = $request->input('user_selected_answer');

        $questionId = $request->input('question_id');

        $userTestId = $request->input('user_test_id');



        $userTestQuestion = UserTestQuestion::where('id', $questionId)->first();



        if ($userTestQuestion) {

            if ($selectedAnswer === $userTestQuestion->correct_answer) {

                $userTestQuestion->correct_status = 1;

            } else {

                $userTestQuestion->correct_status = 0;

            }



            $userTestQuestion->user_selected_answer = $selectedAnswer;

            $userTestQuestion->status = 1;

            $userTestQuestion->save();



            $totalQuestions = UserTestQuestion::where('user_test_id', $userTestId)->count();

            $answeredQuestionsCount = UserTestQuestion::where('user_test_id', $userTestId)

                ->where('status', 1)

                ->count();



            $lastQuestionId = UserTestQuestion::where('user_test_id', $userTestId)

                ->orderBy('id', 'desc')

                ->pluck('id')

                ->first();



            if ($questionId == $lastQuestionId) {

                $correctAnswersCount = UserTestQuestion::where('user_test_id', $userTestId)

                    ->where('correct_status', 1)

                    ->count();



                $percentage = ($correctAnswersCount / $totalQuestions) * 100;



                $userTest = UserTest::where('id', $userTestId)->first();

                if ($userTest) {

                    $userTest->result = $percentage;

                    $userTest->save();

                }



                return response([

                    'status' => true,

                    'complete' => true,

                    'percentage' => $percentage,

                ]);

            } else {

                $firstQuestion = UserTestQuestion::with('options')

                    ->where('status', 0)

                    ->where('user_test_id', $userTestId)

                    ->first();



                $data = [

                    'firstQuestion' => $firstQuestion,

                    'user_test_id' => $userTestId,

                    'answeredQuestionsCount' => $answeredQuestionsCount,

                    'totalQuestions' => $totalQuestions,

                ];



                return response([

                    'status' => true,

                    'complete' => false,

                    'question' => view('client.user_cards.question')->with($data)->render(),

                ]);

            }

        } else {

            return response()->json(['error' => 'Question not found.'], 404);

        }

    }

    public function updateExamStatus(Request $request)
    {
        $userTestId = $request->input('user_test_id');
        $status = $request->input('status');
        $userTest = UserTest::find($userTestId);
        if ($userTest) {
            $userTest->exam_status = $status;
            $totalQuestions = UserTestQuestion::where('user_test_id', $userTestId)->count();
            $correctAnswersCount = UserTestQuestion::where('user_test_id', $userTestId)
                ->where('correct_status', 1)
                ->count();
            $percentage = ($correctAnswersCount / $totalQuestions) * 100;
            $userTest->result = $percentage;
             // Pass certificate condition Check if percentage is 50 or more
            if ($percentage >= 50) {
                $generatedNumber = 'RCS-' . str_pad($userTestId, 6, '0', STR_PAD_LEFT);
                $userTest->pass_certificate_num = $generatedNumber;
            }
            // Special certificate condition Check if percentage is 50 or more
            if ($percentage >= 80) {
                $generatedNumber = 'TTT-' . str_pad($userTestId, 6, '0', STR_PAD_LEFT);
                $userTest->special_certificate_num = $generatedNumber;
            }
            $userTest->save();
            return response()->json(['success' => true, 'result' => $percentage]);
        }
        return response()->json(['success' => false], 400);
    }



    public function pass_certificate($id)
    {
        $user = auth('web')->user();
        $cards = UserCard::findOrFail($id);
        $user_data = User::where('id', $user)->first();
        $certificate_number = UserTest::where('user_id', $user->id)->latest()->first();
        // dd($userTest);
        $data = [
            'cards' => $cards,
            'title' => 'Certificate of Completion',
            'user_data' => $user_data,
            'certificate_number' => $certificate_number,
        ];
        return view('client.user_certificate.card')->with($data);
        exit;
        // Initialize Dompdf with options
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isPhpEnabled', true);
        $dompdf = new Dompdf($options);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->loadHtml($pdfContent);
        $dompdf->render();
        $pdfPath = 'pdfs/' . 'pass_certificate-' . $cards->id . '.pdf';
        file_put_contents(storage_path('app/' . $pdfPath), $dompdf->output());
        return response()->download(storage_path('app/' . $pdfPath));
    }

    public function special_certificate($id)
    {
        $user = auth('web')->user();
        $certificate_number = UserTest::where('user_id', $user->id)->latest()->first();
        // Fetch the user card along with the user and userTests relationships
        $user = auth('web')->user();
        $cards = UserCard::with(['user', 'testUser' => function ($query) {
            $query->orderBy('created_at', 'desc');
        }])->findOrFail($id);
        $latestUserTest = $cards->testUser->first();
        $data = [
            'cards' => $cards,
            'latestUserTest' => $latestUserTest, // Pass latest test
            'title' => 'Certificate of Completion',
            'certificate_number' => $certificate_number,
        ];
        return view('client.user_certificate.certificate')->with($data);
        exit;
        // Initialize Dompdf with options
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $options->set('isPhpEnabled', true);
        $dompdf = new Dompdf($options);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->loadHtml($pdfContent);
        $dompdf->render();
        $pdfPath = 'pdfs/' . 'special_certificate-' . $cards->id . '.pdf';
        file_put_contents(storage_path('app/' . $pdfPath), $dompdf->output());
        return response()->download(storage_path('app/' . $pdfPath));
    }

}

