<?php

namespace App\Http\Controllers;

use App\Models\PartnerPaymentMethod;
use App\Models\User;
use Illuminate\Http\Request;
use Srmklive\PayPal\Services\PayPal as PayPalClient;

class PaypalPaymentController extends Controller
{
    public function index_paypal($id)
    {    
        $data = [
            'id' => $id,
        ];
        return view('paypalPayment')->with($data);
    }

    public function paypal(Request $request)
    {  
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();
        $response = $provider->createOrder([
            "intent" => "CAPTURE",
            "application_context" => [
                "return_url" => route('paypalPayment.success',$request->id), // Pass the ID to success URL
                "cancel_url" => route('paypalPayment.cancel',$request->id)  // Pass the ID to cancel URL
            ],
            "purchase_units" => [
                [
                    "reference_id" => $request->id, // Add the ID in purchase_units for reference
                    "amount" => [
                        "currency_code" => "EUR",
                        "value" => 300
                    ]
                ]
            ]
        ]);

        if (isset($response['id']) && $response['id'] != null) {
            foreach ($response['links'] as $link) {
                if ($link['rel'] === 'approve') {
                    return redirect()->away($link['href']); // Redirect to PayPal approval page
                }
            }
        } else {
            return redirect()->route('paypalPayment.index_paypal',$request->id)->with('error', 'Payment was canceled!'); // Pass the ID to cancel URL
        }
    }

    public function success(Request $request,$id)
    {  
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();
        $response = $provider->capturePaymentOrder($request->token);

        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
           
            // Insert data into database
            $payment = new PartnerPaymentMethod();
            $payment->payment_id = $response['id'];
            $payment->product_name = session()->get('product_name');
            $payment->quantity = session()->get('quantity');
            $payment->amount = $response['purchase_units'][0]['payments']['captures'][0]['amount']['value'];
            $payment->currency = $response['purchase_units'][0]['payments']['captures'][0]['amount']['currency_code'];
            $payment->payer_name = $response['payer']['name']['given_name'];
            $payment->payer_email = $response['payer']['email_address'];
            $payment->payment_status = $response['status'];
            $payment->payment_method = "PayPal";

            // Save the user or transaction ID in the user_id column
            $id = $response['purchase_units'][0]['reference_id'];
            $payment->user_id = $id; // Store the transaction ID in user_id

            $payment->save();

            $user = User::findOrFail($id);
            $user->is_verified = 1;
            $user->save();

            return redirect()->route('partner_login')->with('success', 'Payment completed successfully!');
        } else {
            return redirect()->route('paypalPayment.index_paypal',$id)->with('error', 'Payment was canceled!');
        }
    }

    public function cancel($id)
    { 
        return redirect()->route('paypalPayment.index_paypal',$id)->with('error', 'Payment was canceled!');
    }

}