<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\DianujHashidsTrait;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserCard extends Model
{
    use HasFactory;
    use SoftDeletes;
    use DianujHashidsTrait;

    public function card()
    {
        return $this->belongsTo(Cards::class, 'card_id', 'id');
    }
    public function exam()
    {
        return $this->belongsTo(CardExam::class, 'card_id', 'title');
    }

    public function userTests()
    {
        return $this->hasMany(UserTest::class, 'card_id');
    }


    public function testUser()
    {
        return $this->hasMany(UserTest::class, 'user_id', 'user_id');
    }
    
     public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

}
