@extends('layouts.admin')
@section('page-css')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="index.html"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- Basic Examples -->
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                         <div class="row">
                            <div class="col-md-12">
                                <button class="btn btn-default pull-right add-row"><i class="fa fa-plus"></i>&nbsp;&nbsp; <a
                                        href="{{ route('admin.cards.add') }}" style="text-decoration: none; color:white;">
                                        Add Card</a></button>
                            </div>
                        </div>
                        <div class="body">
                            <div class="table-responsive">
                                <table id="course-table"
                                    class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Title</th>
                                            <th>Category</th>
                                            <th>Price</th>
                                            <th>Card Validate</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($all_data as $all)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $all->title }}</td>
                                                <td>{{ $all->CardCategories->title }}</td>
                                                <td>{{ get_price($all->price) }}</td>
                                                <td>{{  $all->card_validate}}</td>
                                                <td>
                                                    <a  class="btn btn-warning" href="{{ route('admin.cards.edit', $all->hashid) }}"><i class="fas fa-edit"></i></a> &nbsp;&nbsp;
                                                    <a class="btn btn-danger" href="javascript:void(0)" onclick="ajaxRequest(this)" data-url="{{route('admin.cards.delete', $all->hashid)}}" title="Delete"><i class="fas fa-trash"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>


    {{-- <script>
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {}, true);
        });
        $(document).ready(function() {
            getAllCourse();

        });
    </script> --}}

    {{-- <script>
        function getAllCourse() {
            if ($.fn.DataTable.isDataTable('#course-table')) {
                $('#course-table').DataTable().destroy();
            }
            $('#course-table').DataTable({
                processing: true,
                serverSide: true,
                "order": [
                    [0, "desc"]
                ],
                "pageLength": 10,
                "lengthMenu": [10, 50, 100, 150, 500],
                ajax: {
                    url: "{{ route('admin.course.all_course') }}",
                    data: function(d) {
                        d.search = $('input[type="search"]').val();
                    },
                },
                columns: [{
                        data: null,
                        render: function(data, type, row, meta) {
                            return meta.row + 1;
                        },
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'course_id',
                        name: 'course_id',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'course_name',
                        name: 'course_name',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'course_price',
                        name: 'course_price',
                        orderable: true,
                        searchable: false
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: true,
                        searchable: false
                    },
                ],
            });
        }
    </script> --}}
@endsection
