@extends('layouts.admin')
@section('page-css')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="index.html"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>


            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">

                        <div class="body">
                            <h2 class="card-inside-title">{{ $sub_title }}</h2>
                            <form action="{{ route('admin.profile.update') }}" method="post" class="ajaxForm">
                                @csrf


                                <div class="row clearfix">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="">Name</label>
                                            <input type="text" class="form-control" placeholder="Name" name="name"
                                                value="{{ $edit->name ?? '' }}" />
                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="">User Name</label>
                                            <input type="text" class="form-control" placeholder="UserName"
                                                name="username" value="{{ $edit->username ?? '' }}" readonly/>
                                        </div>
                                    </div>

                                </div>


                                <div class="row clearfix">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="">Email</label>
                                            <input type="text" class="form-control" placeholder="Email" name="email"
                                                value="{{ $edit->email ?? '' }}" readonly/>
                                        </div>
                                    </div>
                            </div>
                            @if(!isset($edit->id))
                            <br>

                            <div class="row mb-4">

                                <div class="form-check">
                                    <input type="checkbox" name="check_next" id="stayOnPage" value="1">

                                    <label class="form-check-label" for="stayOnPage">
                                        Stay On this page after i clicked <strong>Save</strong>
                                    </label>
                                </div>


                            </div>

                            @endif
                            <input type="hidden" name="id" value="{{$edit->id}}">
                            <button type="submit" class="btn btn-raised btn-primary btn-round waves-effect">{{isset($edit) ? 'Update' : 'Save'}}</button>
                        </form>

                        </div>


                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">

                        <div class="body">
                            <h2 class="card-inside-title">Update Password</h2>
                            <form action="{{ route('admin.profile.update_password') }}" method="post" class="ajaxForm">
                                @csrf
                                <div class="row clearfix">
                        
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label for="">Current Password</label>
                                        <input type="password" class="form-control" placeholder="Enter current password"
                                            name="current_password" required />
                                    </div>
                                </div>
                            </div>
                            <div class="row clearfix">


                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">New Password</label>
                                        <input type="password" class="form-control" placeholder="Enter New Password"
                                            name="password" required />
                                    </div>
                                </div>

                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="">Confirm Password</label>
                                        <input type="password" class="form-control" placeholder="Confirm New Password"
                                            name="password_confirmation" required />
                                    </div>
                                </div>

                            </div>
                    
                            <input type="hidden" name="id" value="{{$edit->id}}">
                            <button type="submit" class="btn btn-raised btn-primary btn-round waves-effect">{{isset($edit) ? 'Update' : 'Save'}}</button>
                        </form>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>


    <script>
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {}, true);
        });
    </script>
@endsection
