@extends('layouts.admin')

@section('page-css')
    <link href="{{ asset('front/assets/plugins/fileUpload/fileUpload.css') }}" rel="stylesheet" />
    <link href="{{ asset('front') }}/assets/plugins/datatable/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.0/fullcalendar.min.css" />
@endsection
@section('content')

<div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-xl-3 row-cols-xxl-3">
    <div class="col">
        <div class="card radius-10 border-0 border-start border-primary border-3">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Ads Budget</p>
                        <h4 class="mb-0 text-primary">{{get_price($ads_budget->spend_amount)}}</h4>
                    </div>
                    <div class="ms-auto widget-icon bg-primary text-white">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10 border-0 border-start border-primary border-3">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">Remaining Balance</p>
                        <h4 class="mb-0 text-primary">{{get_price($remaining_balance)}}</h4>
                    </div>
                    <div class="ms-auto widget-icon bg-primary text-white">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10 border-0 border-start border-secondary border-3">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">EST Monthly Payment</p>
                        <h3 class="mb-0 text-danger">{{get_price($this_week_pay)}}</h3>
                    </div>
                    <div class="ms-auto widget-icon bg-secondary text-white">
                        <i class="bi bi-currency-dollar"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col">
        <div class="card radius-10 border-0 border-start border-pink border-3">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="">
                        <p class="mb-1">PPC Leads Generated</p>
                        <h3 class="mb-0 text-pink">{{$total_ppc_leads}}</h4>
                    </div>
                    <div class="ms-auto widget-icon bg-pink text-white">
                        <i class="fa-solid fa-people-group"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



    <div class="row">
        <div class="col-xl-12 mx-auto">
            <div class="card">
                <div class="card-body">
                    <div class="card-title d-flex align-items-center">
                        <h5 class="">Ads Requests</h5>
                    </div>
                    <hr>
                    <div class="table-responsive">

                        <div id="data-info" data-id="{{ $id }}" data-subaccountid="{{ $subAccountId }}"></div>


                        <table id="ads-template-table" class="table table-striped table-bordered" style="width:100%">
                            <thead>
                                <tr>
                                    <th>S NO:</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Type</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>







@endsection
@section('page-scripts')
    <script src="{{ asset('front') }}/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/table-datatable.js"></script>
    <script>
        var leadDataCount = 0;
            $(document).ready(function() {
                getAllAds();
            });




            function getAllAds() {
                if ($.fn.DataTable.isDataTable('#ads-template-table')) {
                    $('#ads-template-table').DataTable().destroy();
                }
                $('#ads-template-table').DataTable({
                    processing: true,
                    serverSide: true,
                    "order": [
                        [0, "desc"]
                    ],
                    "pageLength": 10,
                    "lengthMenu": [10, 50, 100, 150, 500],
                    ajax: {
                        url: "{{ route('admin.view_progress_datatable', ['id' => $id, 'subAccountId' => $subAccountId]) }}",
                        data: function(d) {
                            d.search = $('input[type="search"]').val();
                        },
                    },
                    columns: [{
                            data: null,
                            render: function(data, type, row, meta) {
                                return meta.row + 1;
                            },
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'name',
                            name: 'name',
                            orderable: false,
                            searchable: false
                        },
                        {
                            data: 'email',
                            name: 'email',
                            orderable: true,
                            searchable: false
                        },
                        {
                            data: 'mobile_number',
                            name: 'mobile_number',
                            orderable: true,
                            searchable: false
                        },
                        {
                            data: 'user_type',
                            name: 'user_type',
                            orderable: true,
                            searchable: false
                        },
                        // {
                        //     data: 'action',
                        //     name: 'action',
                        //     orderable: true,
                        //     searchable: false
                        // },
                    ],
                });
            }


    </script>




@endsection
