@section('title', 'Login')
@php
    $title = 'login';
@endphp
@section('content')
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>OSHTA</title>
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/fontawesome-all.min.css">
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/iofrm-style.css">
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/iofrm-theme15.css">
        <style>
            .form-control {
                background-color: #f7f7f7 !important;
            }

            .form-content .form-items {
                max-width: 100% !important;
            }
        </style>
    </head>

    <body>
        <div class="form-body">
            <div class="website-logo">
                <a href="#">
                    <div>
                        <img class="logo-size" src="{{ asset('front') }}/assets/images/OSHTA-Logo.png" alt="">
                    </div>
                </a>
            </div>
            <div class="row">
                <div class="img-holder">
                    <div class="info-holder mt-4">
                        <h3 class="mt-5">Get more things done with Loggin platform.</h3>
                        <p>Access to the most powerfull tool in the entire design and web industry.<br><br>
                            Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod
                            maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.</p>
                    </div>
                </div>
                <div class="form-holder">
                    <div class="form-content">
                        <div class="form-items">
                            <div class="page-links">
                                <a href="{{ route('login') }}">Login</a>
                                <a href="{{ route('Userregister') }}"class="active">Register</a>
                            </div>
                            <form class="form-body registerForm" method="POST" action="{{ route('auth.User_register_submit') }}"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-lg-6 col-md-6 mt-4">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5" name="full_name"
                                                    value="{{ old('full_name') }}" id="inputName" placeholder="Full Name" required>
                                            </div>
                                        </div>
                                        @error('full_name')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <label for="inputDate" class="small text-dark">Your Date Of Birth</label>
                                            <div class="input-group">
                                                <input type="date" class="form-control radius-30 ps-5" name="date_of_birth"
                                                    value="{{ old('date_of_birth') }}" id="inputDate" placeholder="Date of birth" required>
                                            </div>
                                        </div>
                                        @error('date_of_birth')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5" name="profession"
                                                    value="{{ old('profession') }}" id="inputName"
                                                    placeholder="Profession">
                                            </div>
                                        </div>
                                        @error('profession')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5" name="experience"
                                                    value="{{ old('experience') }}" placeholder="Experience (in years)">
                                            </div>
                                        </div>
                                        @error('experience')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5" name="country"
                                                    value="{{ old('country') }}" placeholder="Enter Country Name">
                                            </div>
                                        </div>
                                        @error('country')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="email" class="form-control radius-30 ps-5" name="email"
                                                    value="{{ old('email') }}" id="inputEmailAddress"
                                                    placeholder="Email Address">
                                            </div>
                                        </div>
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                              

                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="password" class="form-control radius-30 ps-5"
                                                    name="password" value="{{ old('password') }}" id="inputNewPassword"
                                                    placeholder="Enter Password" required>
                                            </div>
                                            <small class="text-danger">Password must be at least 8 characters.</small>
                                        </div>
                                        @error('password')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="password" class="form-control radius-30 ps-5"
                                                    name="confirm_password" value="{{ old('confirm_password') }}"
                                                    id="inputConfirmPassword" placeholder="Confirm Password" required>
                                            </div>
                                        </div>
                                        @error('confirm_password')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                
                                  <div class="row">
                                    <div class="col-lg-12 col-md-6">
                                        <div class="form-group">
                                            <label for="" class="small text-dark">Profile Image</label>
                                            <small class="text-danger">(Image must be at least  png,jpeg,jpg.)</small>
                                            <div class="input-group">
                                                <input type="file" class="form-control radius-30 ps-5" name="profile_image"
                                                    value="" style="height: 45px;" accept=".jpg, .png, .jpeg" required>
                                            </div>
                                            
                                        </div>
                                        @error('profile_image')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row clearfix mt-3">
                                    <div class="col-12 text-center">
                                        <button type="submit" id="submitButton" class="btn btn-primary btn-lg radius-30"
                                            style=" width: 400px; font-size: 18px; ">Sign Up</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="{{ asset('front') }}/partner_assets/js/jquery.min.js"></script>
        <script src="{{ asset('front') }}/partner_assets/js/popper.min.js"></script>
        <script src="{{ asset('front') }}/partner_assets/js/bootstrap.min.js"></script>
        <script src="{{ asset('front') }}/partner_assets/js/main.js"></script>
        <script src="{{ asset('front') }}/assets/js/danidev.js"></script>
    </body>

    </html>
@section('page-script')
    <script>
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {}, true);
        });
    </script>
@endsection
