@section('title', 'Login')
@php
    $title = 'login';
@endphp
@section('content')
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>OSHTA</title>
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/bootstrap.min.css">
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/fontawesome-all.min.css">
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/iofrm-style.css">
        <link rel="stylesheet" type="text/css" href="{{ asset('front') }}/partner_assets/css/iofrm-theme15.css">
        <style>
            .form-control {
                background-color: #f7f7f7 !important;
            }

            .form-content .form-items {
                max-width: 100% !important;
            }
        </style>
    </head>

    <body>
        <div class="form-body">
            <div class="website-logo">
                <a href="#">
                    <div>
                        <img class="logo-size" src="{{ asset('front') }}/assets/images/OSHTA-Logo.png" alt="">
                    </div>
                </a>
            </div>
            <div class="row">
                <div class="img-holder">
                    <div class="info-holder mt-4">
                        <h3 class="mt-5">Get more things done with Loggin platform.</h3>
                        <p>Access to the most powerfull tool in the entire design and web industry.<br><br>
                            Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod
                            maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.</p>
                    </div>
                </div>
                <div class="form-holder">
                    <div class="form-content">
                        <div class="form-items">
                            <div class="page-links">
                                <a href="{{ route('partner_login') }}">Login</a>
                                <a href="{{ route('partner_register') }}" class="active">Register Partner</a>
                                {{-- <a href="{{ route('Userregister') }}">Register</a> --}}
                                {{-- <a href="{{ route('register') }}"class="active">Register as a Partner</a> --}}
                            </div>
                            <form class="form-body registerForm" method="POST" action="{{ route('auth.register.submit') }}"
                                enctype="multipart/form-data">
                                @csrf
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control" name="institute_name"
                                                    value="{{ old('institute_name') }}" id="inputName"
                                                    placeholder="Institute Name" required>
                                            </div>
                                        </div>
                                    </div>
                                    @error('institute_name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5"
                                                    name="head_institute" value="{{ old('head_institute') }}"
                                                    id="inputName" placeholder="Head of the institute" required>
                                            </div>
                                        </div>
                                        @error('head_institute')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5"
                                                    value="{{ old('phone_number') }}"
                                                    oninput="this.value = this.value.replace(/[^0-9]/g, '');"
                                                    name="phone_number" id="inputName" placeholder="Phone Number" required>
                                            </div>
                                        </div>
                                        @error('phone_number')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="email" class="form-control radius-30 ps-5" name="email"
                                                    value="{{ old('email') }}" id="inputEmailAddress"
                                                    placeholder="Email Address">
                                            </div>
                                        </div>
                                        @error('email')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5" name="website"
                                                    value="{{ old('website') }}" id="inputName" placeholder="Website">
                                            </div>
                                        </div>
                                        @error('website')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5"
                                                    name="business_registration" value="{{ old('business_registration') }}"
                                                    placeholder="Business Registration">
                                            </div>
                                        </div>
                                        @error('business_registration')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-lg-12 col-md-12">
                                        <div class="form-group">
                                            <textarea class="form-control" rows="3" name="address" value="" id="inputName"
                                                placeholder="Please type Institute Address" required>{{ old('address') }}</textarea>
                                        </div>
                                        @error('address')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5" name="country"
                                                    value="{{ old('country') }}" placeholder="Enter Country Name">
                                            </div>
                                        </div>
                                        @error('country')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="text" class="form-control radius-30 ps-5" name="city"
                                                    value="{{ old('city') }}" placeholder="Enter city Name">
                                            </div>
                                        </div>
                                        @error('city')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row mt-3">
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="password" class="form-control radius-30 ps-5"
                                                    name="password" value="{{ old('password') }}" id="inputNewPassword"
                                                    placeholder="Enter Password" required>
                                            </div>
                                            <small class="text-danger">Password must be at least 8 characters.</small>
                                        </div>
                                        @error('password')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6 col-md-6">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <input type="password" class="form-control radius-30 ps-5"
                                                    name="confirm_password" value="{{ old('confirm_password') }}"
                                                    id="inputConfirmPassword" placeholder="Confirm Password" required>
                                            </div>
                                        </div>
                                        @error('confirm_password')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12 col-md-12 d-flex align-items-center">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <label class="input-group-label mt-2" for="trainer-cv">Trainer CV:</label>

                                                <input type="file" class="form-control radius-30 ps-5" name="pdf"
                                                    id="profile_pdf" placeholder="Trainer CV" style=" height: 47px;"
                                                    accept="application/pdf" value="{{ old('pdf') }}" required>
                                            </div>
                                            <small class="text-danger">Upload only PDF File.</small>
                                        </div>
                                        @error('pdf')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="row clearfix mt-3">
                                    <div class="col-12 text-center">
                                        <button type="submit" id="submitButton" class="btn btn-primary btn-lg radius-30"
                                            style=" width: 400px; font-size: 18px; ">Sign Up</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <script src="{{ asset('front') }}/partner_assets/js/jquery.min.js"></script>
        <script src="{{ asset('front') }}/partner_assets/js/popper.min.js"></script>
        <script src="{{ asset('front') }}/partner_assets/js/bootstrap.min.js"></script>
        <script src="{{ asset('front') }}/partner_assets/js/main.js"></script>
        <script src="{{ asset('front') }}/assets/js/danidev.js"></script>
    </body>
    </html>
@section('page-script')
    <script>
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {}, true);
        });
    </script>
@endsection
