<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Certificate of Achievement</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Times New Roman', Times, serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            padding: 0;
        }

        .certificate-container {
            border: 10px solid #e2cb90;
            padding: 40px;
            max-width: 800px;
            text-align: center;
            background-color: white;
            position: relative;
        }

        .certificate-header img {
            /* height: 90px; */
            margin-bottom: 20px;
        }

        .certificate-title {
            font-size: 32px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .certificate-subheader {
            font-size: 20px;
            margin-bottom: 40px;
        }

        .recipient-name {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .certificate-body {
            font-size: 18px;
            margin-bottom: 30px;
        }

        .organization-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .signature {
            margin-top: 50px;
            font-style: italic;
            font-size: 20px;
        }

        .footer {
            font-size: 16px;
            margin-top: 40px;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 20px;
        }

        .qr-code {
            height: 100px;
            margin-top: 20px;
            margin-left: 10px;
        }
    </style>
</head>

<body>
    <div class="certificate-container">
        <div class="certificate-header">
            <img src="{{'data:image/png;base64,'.base64_encode(file_get_contents(public_path('/front/assets/images/OSHTA-Logo.png')))}}" style="width: 150px; hight:150px" alt="OSHTA Logo">
            <p class="certificate-title">CERTIFICATE OF ACHIEVEMENT</p>
        </div>
        <div class="certificate-subheader">
            This certificate is awarded to
        </div>
        <div class="recipient-name">
            {{ $student->name }}
        </div>
        <div class="certificate-body">
            on successfully completing <br><strong>{{ $student->Course->course_name }}</strong><br>
            a course approved and validated by the<br><strong>OSHTA</strong><br>
            in association with Approved Training Partner<br>
            <div class="organization-name">Stairs International</div>
            Center Number: <strong>0295</strong><br>
            Certificate No:<strong> {{ $student->certification_number }} </strong><br>
            Issued on: <strong>{{ date('F j, Y') }}</strong><br>
            Validity: <strong>Life-Time</strong>
        </div>
        <div class="signature">
            <img src="{{'data:image/png;base64,'.base64_encode(file_get_contents(public_path('/front/assets/images/Samantha_Signature.png')))}}" alt="Signature" class="img-fluid" style="height: 40px;"><br>
            Training Director
        </div>
        <div class="footer">
            <a href="http://www.oshta.at" target="_blank">www.oshta.at</a>

        </div>
        <div class="qrcode_div">
            <img src="{{'data:image/png;base64,'.base64_encode(file_get_contents(public_path('/front/assets/images/Qrcode.png')))}}" class="qr-code" alt="QR Code">
        </div>
    </div>
</body>

</html>
