<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Approval Waiting</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box; 
        }
        .main_div {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            background-color: grey;
            height: 100vh;
            width: 100%;
        }
        .logo-size {
            margin-bottom: 20px; /* Space between image and the header div */
        }
        .header {
            width: 500px;
            height: 300px;
            background-color: white;
            border-radius: 10px; 
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center; 
            display: flex;
            flex-direction: column;
            justify-content: center; 
        }
        button {
            background-color: #007bff;
            color: white;
            padding: 10px 20px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            font-size: 1rem;
            width: 100%;
        }
        button:hover {
            background-color: #0056b3;
        }
        label {
            font-size: 1.1rem;
            margin-bottom: 10px;
            display: block;
        }
        input[type="text"] {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }
        h3{
            margin-bottom: 15px;
        }
        img{
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="main_div">
        <div class="header" style=" align-items: center; ">
            <img src="{{ asset('front') }}/assets/images/OSHTA-Logo.png" alt="logo" width="100px" >
            <form action="{{ route('handle_verification') }}" method="POST">
                @csrf
                <div><h3>Certification Number</h3></div>
                <input type="text" id="certification_number" name="certification_number" required placeholder="Enter Certification Number">
                <button type="submit">Verify</button>
            </form>
        </div>
    </div>
</body>
</html>