@extends('layouts.front')
@section('page-css')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection
@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- Basic Examples -->
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="text-right">
                            <a href="{{ route('user.invoice.all') }}" class="btn btn-primary text-white">
                                <i class="fas fa-arrow-left"></i> Back
                            </a>
                        </div>
                        <div class="body">
                            <div class="table-responsive">
                                <table id="course-table"
                                    class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Student Name</th>
                                            <th>Date Of Birth</th>
                                            <th>Course Name</th>
                                            <th>Marks</th>
                                            <th>Status</th>
                                            <th>Certification Number</th>
                                            <th>Certificate</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($students as $student)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $student->name }}</td>
                                                <td>{{ $student->date_of_birth }}</td>
                                                <td>{{ $student->Course->course_name }}</td>
                                                <td>{{ $student->marks }}</td>
                                                <td>{{ $student->status }}</td>
                                                <td>{{ $student->certification_number }}</td>
                                                <td>
                                                    @if($student->status == 'pass')
                                                    <button type="button" class="btn btn-primary btn-sm">
                                                        <a href="{{ route('user.invoice.certificate', $student->id) }}" class="text-white">Download &nbsp;<i class="fas fa-download"></i></a>
                                                    </button>
                                                    @else
                                                    <button type="button" class="btn btn-primary btn-sm" hidden>
                                                        <a href="#" class="text-white">Download &nbsp;<i class="fas fa-download"></i></a>
                                                    </button>
                                                    @endif
                                                </td>
                                                <td>
                                                @if($student->marks == '')    
                                                    <button type="button" class="btn btn-primary btn-sm"
                                                            data-toggle="modal" data-target="#invoiceModal"
                                                            data-id="{{ $student->id }}">
                                                        <i class="fas fa-cog"></i>
                                                    </button>
                                                @else
                                                    -
                                                @endif    
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        {{-- modal --}}
        <div class="modal fade" id="invoiceModal" tabindex="-1" role="dialog" aria-labelledby="invoiceModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="partnerModalLabel">Marks</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form id="invoiceForm" method="POST" action="{{ route('user.invoice.save') }}">
                            @csrf
                            <input type="hidden" name="student_id" id="student_id">
                            <div class="form-group">
                                <label for=""><strong>Marks</strong></label>
                                <input type="text" class="form-control" name="marks" placeholder="Enter Marks" required>
                            </div>
                            <div class="d-flex justify-content-end mt-3">
                                <button class="btn btn-primary form-submit-btn" type="submit">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
        <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
        <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
        <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
        <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
        <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
        <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>
   
    <script>
        $('#invoiceModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget); 
            var studentId = button.data('id'); 
            
            var modal = $(this);
            modal.find('#student_id').val(studentId);
        });
    </script>
    <script>
        $('#invoiceForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var formData = new FormData(this);
            my_ajax(url, formData, 'post', function(res) {

            }, true);
        });
    </script>
    <script>
        $('#invoiceModal').on('hidden.bs.modal', function() {
            $('.modal-backdrop').remove();
        });
        $('#invoiceModal').on('hidden.bs.modal', function() {
            $('.modal-backdrop').remove();
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function removeBackdrop() {
                var backdrops = document.querySelectorAll('.modal-backdrop.fade.show');
                backdrops.forEach(function(backdrop) {
                    backdrop.remove();
                });
            }
            removeBackdrop();

            const observer = new MutationObserver(function(mutations) {
                mutations.forEach(function(mutation) {
                    if (mutation.addedNodes.length) {
                        removeBackdrop();
                    }
                });
            });
            observer.observe(document.body, {
                childList: true,
                subtree: true
            });
        });
    </script>
@endsection
