@extends('layouts.front')

@section('page-css')
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="{{ asset('front') }}/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
@endsection

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2>{{ $title }}</h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">{{ $title }}</li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="body">
                            <div class="table-responsive">
                                <table id="course-table" class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Card Name</th>
                                            <th>Exam Name</th>
                                            <th>Price</th>
                                            <th>Purchased Date</th>
                                            <th>Expire Date</th>
                                            <th>Result</th>
                                            <th>Download Certificate</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($all_data as $all)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $all->card_name }}</td>
                                                <td>{{ $all->exam_name }}</td>
                                                <td>{{ get_price($all->card_price) }}</td>
                                                <td>{{ get_date($all->created_at) }}</td>
                                                <td>{{ get_date($all->created_at->addYear()) }}</td>
                                                <td>
                                            @if ($all->test_result != '')
                                            <p><strong>Result: {{ $all->test_result }}% </strong>
                                                @if ($all->test_result >= 50)
                                                <strong>(Pass)</strong>
                                                @else
                                                <strong>(Fail)</strong>
                                                @endif
                                            </p>
                                            @endif
                                        </td>

                                                <td>
                                                    @if($all->test_result !== null)
                                                        @if($all->test_result >= 50)
                                                            @if ($all->test_result >= 80)
                                                            <button type="button" class="btn btn-primary btn-sm">
                                                                <a href="{{ route('user.cards.special_certificate', $all->id) }}" class="text-white" target="_blank">Special Certificate &nbsp;<i class="fas fa-download"></i></a>
                                                            </button><br>
                                                            <button type="button" class="btn btn-primary btn-sm">
                                                                <a href="{{ route('user.cards.pass_certificate', $all->id) }}" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                                            </button>
                                                            @else
                                                            <button type="button" class="btn btn-primary btn-sm">
                                                                <a href="{{ route('user.cards.pass_certificate', $all->id) }}" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                                            </button>
                                                            @endif
                                                        
                                                        @else
                                                            <span>-</span>
                                                        @endif
                                                    @else
                                                        <span>-</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @php
                                                        $purchasedDate = $all->created_at;
                                                        $currentDate = \Carbon\Carbon::now();
                                                        $daysDifference = $currentDate->diffInDays($purchasedDate);
                                                        $test = $all->userTests->first(); 
                                                    @endphp
                                                
                                                    @if($daysDifference <= 30 && ($all->test_result < 50))
                                                            <a href="{{ route('user.cards.save_exams', hashids_encode($all->card_id)) }}">Attempt Exam</a>
                                                    @else
                                                        <h5>-</h5>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection




@section('page-scripts')
    <!-- Jquery DataTable Plugin Js -->
    <script src="{{ asset('front') }}/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="{{ asset('front') }}/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="{{ asset('front') }}/assets/js/pages/tables/jquery-datatable.js"></script>


    {{-- <a href="{{ route('user.invoice.certificate', $student->id) }}" class="text-white">Download &nbsp;<i class="fas fa-download"></i></a> --}}
@endsection
