@csrf
<input type="hidden" name="user_test_id" value="{{ $user_test_id }}">
<input type="hidden" name="question_id" value="{{ $firstQuestion->id }}">

<div class="body mt-3">
    <div class="row clearfix">
        <div class="col-sm-12">
            @if ($firstQuestion)
            <div class="form-group">
                <div class="d-flex justify-content-between align-items-center"
                    style="font-size: 20px;">
                    <span>Question</span>
                    <span><strong>{{ $answeredQuestionsCount+1 }}/{{ $totalQuestions }}</strong></span>
                </div>
                <h4>{{ $firstQuestion->question }}</h4>
            </div>

            @foreach ($firstQuestion->options as $option)
            <div class="option-box p-3 mb-3 border rounded">
                <div class="form-check">
                    <input class="form-check-input" type="{{ $firstQuestion->type }}"
                        name="user_selected_answer"
                        value="{{ $option->answer_options }}"
                        id="option{{ $option->id }}">
                    <label class="form-check-label"
                        for="option{{ $option->id }}">
                        {{ $option->answer_options }}
                    </label>
                </div>
            </div>
        @endforeach
            @else
                <p>No questions available.</p>
            @endif
        </div>
    </div>
    <div class="d-flex justify-content-center mt-4">
        <button type="submit"
            class="btn btn-raised btn-primary btn-round waves-effect form-submit-btn">Submit</button>
    </div>
</div>