<div class="row mb-2">
    <div class="col-6">
        <div class="form-group mb-2">
            <textarea class="form-control" name="keywords" id="keywords" cols="30" rows="10">{{ old('keywords') }}</textarea>
            @error('keywords')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
    </div>
    <div class="col-6">
        <div class="form-group mb-2">
            <label for="inputName" class="form-label">Keyword Match Types
                <span class="text-danger fw-bold">*</span></label>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="keyword_match_types" id="keywords-match-type-phrase" value="PHRASE" {{ old('keyword_match_types') == 'PHRASE' ? 'checked' : '' }}>
                <label class="form-check-label" for="keywords-match-type-phrase">
                    Phrase match
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="keyword_match_types" id="keywords-match-type-exact" value="EXACT" {{ old('keyword_match_types') == 'EXACT' ? 'checked' : '' }}>
                <label class="form-check-label" for="keywords-match-type-exact">
                    Exact match
                </label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="radio" name="keyword_match_types" id="keywords-match-type-board" value="BOARD" {{ old('keyword_match_types') == 'BOARD' ? 'checked' : '' }}>
                <label class="form-check-label" for="keywords-match-type-board">
                    Board match
                </label>
            </div>
            @error('keyword_match_types')
                <div class="invalid-feedback">
                    {{ $message }}
                </div>
            @enderror
        </div>
    </div>
</div>