
<?php $__env->startSection('page-css'); ?>
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
    <!-- Bootstrap Select Css -->
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/bootstrap-select/css/bootstrap-select.css" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2><?php echo e($title); ?></h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row clearfix">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <div class="card">
                        <div class="header">
                            <h2><strong><?php echo e($title); ?></strong></h2>

                        </div>
                        <div class="body mt-2">
                            <form action="<?php echo e(route('user.student.store')); ?>" method="post" class="ajaxForm">
                                <?php echo csrf_field(); ?>
                                <div class="col-md-12 col-sm-12 table-responsive">
                                    <div class="row ">
                                        <table class="table" id="new-table" style="height: 250px;">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">Name</th>
                                                    <th class="text-center">Date Of Birth</th>
                                                    <th class="text-center">Course Name</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody id="add_row">
                                                <?php for($i = 0; $i < 1; $i++): ?>
                                                    <tr>
                                                        <td>
                                                            <div class="input-group">
                                                                <span class="input-group-addon"></span>
                                                                <input type="text" name="name[]"
                                                                    class="form-control date" placeholder="John Doe"
                                                                    required>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <span class="input-group-addon"><i
                                                                        class="zmdi zmdi-calendar"></i> </span>
                                                                <input type="date" name="date_of_birth[]"
                                                                    class="form-control date" placeholder="Ex: 30/07/1999"
                                                                    required>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <select name="course_name[]" class="form-control z-index show-tick course-select" required>
                                                                    <option value="">Please select one</option>
                                                                    <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($course->id); ?>" data-price="<?php echo e($course->course_price); ?>" data-id="<?php echo e($i); ?>">
                                                                            <?php echo e($course->course_name); ?>

                                                                        </option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="hidden" name="course_price[]"
                                                                    class="form-control price_<?php echo e($i); ?>">
                                                            </div>
                                                        </td>

                                                        <td style="text-align: right;">
                                                            <a class="btn btn-danger text-white delete-row"><i
                                                                    class="fas fa-trash-alt"></i></a>
                                                        </td>
                                                    </tr>
                                                <?php endfor; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    <div>
                                        <a class="btn btn-primary text-white" id="add_more_items">
                                            <i class="fas fa-plus"></i> Add More</a>
                                    </div>
                                    <button type="submit"
                                        class="btn btn-success btn-lg text-white mt-3 mb-3 form-submit-btn">Submit</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <!-- Jquery DataTable Plugin Js -->
    <script src="<?php echo e(asset('front')); ?>/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script>
        $('.ajaxForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');
            var param = new FormData(this);
            my_ajax(url, param, 'post', function(res) {}, true);
        });

        $(document).ready(function() {
            $('.course-select').change(function() {
                var selectedPrice = $(this).find(':selected').data('price');
                var id = $(this).find(':selected').data('id');
                $('.price_' + id).val(selectedPrice);
                // Do something with the selected price
            });
        });
    </script>
    <script>
        let rowIndex = 1;

        // Add Row
        $('#add_more_items').click(function() {
            rowIndex++;
            const newRow = `
        <tr>
            <td>
                <div class="input-group">
                    <span class="input-group-addon"></span>
                    <input type="text" name="name[]" class="form-control" placeholder="John Doe" required>
                </div>
            </td>
            <td>
                <div class="input-group">
                    <span class="input-group-addon"><i class="zmdi zmdi-calendar"></i></span>
                    <input type="date" name="date_of_birth[]" class="form-control" placeholder="Ex: 30/07/2016" required>
                </div>
            </td>
            <td>
                <div class="input-group">
                    <select name="course_name[]" class="form-control z-index show-tick course-select" data-id="${rowIndex}" required>
                        <option value="">Please select one</option>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($course->id); ?>" data-price="<?php echo e($course->course_price); ?>">
                                <?php echo e($course->course_name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </td>
            <td>
                <div class="input-group">
                    <input type="hidden" name="course_price[]" class="form-control price_${rowIndex}">
                </div>
            </td>
            <td style="text-align: right;">
                <a class="btn btn-danger text-white delete-row"><i class="fas fa-trash-alt"></i></a>
            </td>
        </tr>
    `;
            $('#add_row').append(newRow);

            // Reinitialize Bootstrap Select for the new row
            $('.course-select').selectpicker('refresh');
        });
        $(document).on('change', '.course-select', function() {
            var selectedPrice = $(this).find(':selected').data('price');
            var id = $(this).data('id');
            $('.price_' + id).val(selectedPrice);
        });
        // Delete Row
        $('#add_row').on('click', '.delete-row', function() {
            $(this).closest('tr').remove();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\oshta\resources\views/client/student/add_student.blade.php ENDPATH**/ ?>