<style>
    .result-container {
        padding-top: 10px;
    }

    .result-container p {
        font-size: 1rem;
        line-height: 1.5;
    }
</style>

<?php $__env->startSection('page-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2><?php echo e($title); ?></h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="#"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('user.dashboard')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>

            <?php if(session('success')): ?>
                <div class="alert alert-success" id="flash-message">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger" id="flash-message">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="row clearfix">
                <?php $__currentLoopData = $all_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $all): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center position-relative">
                            <div class="body position-relative" style="height:460px;">
                                <p class="m-b-20">
                                    <i class="fas fa-medal zmdi-hc-3x col-primary"></i>
                                </p>
                                <h4 class="m-b-10"><?php echo e($all->title); ?></h4>
                                <p style="display: none;">Exam: <?php echo e($all->exam->title ?? ''); ?></p>
                                <p>Category: <?php echo e($all->CardCategories->title); ?></p>
                                <?php if($all->userCard): ?>
                                    <p>Exam Questions: 50</p>
                                <?php else: ?>
                                    <p>Price: <?php echo e(get_price($all->price)); ?></p>
                                <?php endif; ?>
                                <?php
                                $alreadyPurchased = DB::table('user_cards')
                                    ->where('user_id', auth('web')->id())
                                    ->where('card_id', $all->id)
                                    ->exists();
                            ?>
                                <?php if($all->userCard): ?>
                                    <p><strong>Purchase Date:</strong> <?php echo e(get_date($all->userCard->created_at)); ?></p>

                                     <?php if($all->test_result >= 50): ?>
                                        <p><strong>Expire Date:</strong> <?php echo e(get_date($all->userCard->created_at->addYear())); ?></p>
                                    <?php else: ?>
                                         <p><strong>Exam Deadline:</strong> <?php echo e(get_date($all->userCard->created_at->addMonth())); ?></p>
                                    <?php endif; ?>

                                <?php endif; ?>

                                <div>


                                    <?php if($alreadyPurchased): ?>
                                        <span class="badge badge-success">Purchased</span> <br>

                                        <?php
                                            $purchasedDate = $all->userCard->created_at;
                                            $currentDate = \Carbon\Carbon::now();
                                            $daysDifference = $currentDate->diffInDays($purchasedDate);
                                        ?>
                                       <?php if($all->test_result != ''): ?>
                                       <p><strong>Result: <?php echo e($all->test_result); ?>% </strong>
                                            <?php if($all->test_result >= 50): ?>
                                                <strong>(Pass)</strong>
                                            <?php else: ?>
                                                <strong>(Fail)</strong>
                                            <?php endif; ?>
                                        </p>
                                        <?php endif; ?>
                                        <?php if($daysDifference <= 30 && ($all->test_result < 50)): ?>
                                            <a href="<?php echo e(route('user.cards.save_exams', hashids_encode($all->id))); ?>"
                                                class="btn btn-success">Attempt Exam</a>
                                        <?php else: ?>
                                            <span></span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <a class="btn btn-warning buy-card form-submit-btn"
                                            data-card-id="<?php echo e($all->id); ?>" data-card-name="<?php echo e($all->title); ?>"
                                            data-exam-name="<?php echo e($all->exam->title ?? ''); ?>" data-card-price="<?php echo e($all->price ?? ''); ?>"
                                            href="<?php echo e(route('user.cards.buy_card',$all->id)); ?>">
                                            <i class="fas fa-shopping-cart"></i>&nbsp;&nbsp;Buy Now
                                        </a>
                                    <?php endif; ?>
                                </div>

                                <div>
                                    <?php if($all->test_result === null): ?>
                                        <span></span>
                                    <?php else: ?>
                                        <?php if($all->test_result >= 50): ?>
                                            <?php if($all->test_result >= 80): ?>
                                            <button type="button" class="btn btn-primary btn-sm">
                                                <a href="<?php echo e(route('user.cards.special_certificate', $all->userCard->id)); ?>" class="text-white" target="_blank">Special Certificate &nbsp;<i class="fas fa-download"></i></a>
                                            </button>
                                            <button type="button" class="btn btn-primary btn-sm">
                                                <a href="<?php echo e(route('user.cards.pass_certificate', $all->userCard->id)); ?>" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                            </button>
                                            <?php else: ?>
                                            <button type="button" class="btn btn-primary btn-sm">
                                                <a href="<?php echo e(route('user.cards.pass_certificate', $all->userCard->id)); ?>" class="text-white" target="_blank">Pass Certificate &nbsp;<i class="fas fa-download"></i></a>
                                            </button>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span></span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <!-- Jquery DataTable Plugin Js -->
    <script src="<?php echo e(asset('front')); ?>/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/js/pages/tables/jquery-datatable.js"></script>

<script>
    // Wait 3 seconds before fading out the flash message
    setTimeout(function() {
        var flashMessage = document.getElementById('flash-message');
        if (flashMessage) {
            flashMessage.style.transition = 'opacity 0.5s ease'; // Smooth transition
            flashMessage.style.opacity = '0'; // Hide the message
            setTimeout(function() {
                flashMessage.remove(); // Remove the element from DOM after fading out
            }, 500); // Wait for the fade-out to finish
        }
    }, 3000); // Display for 3 seconds before hiding
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\oshta_new\resources\views/client/user_cards/all_cards.blade.php ENDPATH**/ ?>