<style>
    .modal-body p {
        margin-bottom: 10px;
    }

    .modal-body p strong {
        display: inline-block;
        width: 150px;
        /* Adjust the width as needed */
    }

    .modal-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #dee2e6;
    }

    .modal-footer {
        background-color: #f8f9fa;
        border-top: 1px solid #dee2e6;
    }

    .btn-secondary {
        background-color: #6c757d;
    }
</style>

<?php $__env->startSection('page-css'); ?>
    <!-- JQuery DataTable Css -->
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2><?php echo e($title); ?></h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="index.html"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- Basic Examples -->
            <div class="row clearfix">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="body">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped table-hover js-basic-example dataTable">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Institute Name</th>
                                            <th>Head Institute</th>
                                            <th>Phone Number</th>
                                            <th>Approve</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $partner_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($partner->institute_name); ?></td>
                                                <td><?php echo e($partner->head_institute); ?></td>
                                                <td><?php echo e($partner->phone_number); ?></td>
                                                <td>
                                                    <?php if($partner->is_verified == 0): ?>
                                                        <button type="button" class="btn btn-warning approveModal"
                                                            data-data="<?php echo e($partner); ?>">
                                                            Pending
                                                        </button>
                                                    <?php elseif($partner->is_verified == 1): ?>
                                                        <span class="badge badge-success">Approved</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a href="#" class="button button-small view_partner_details"
                                                        data-data="<?php echo e($partner); ?>" title="View">
                                                        <i class="fas fa-eye"></i>
                                                    </a>&nbsp;&nbsp;
                                                    <?php if($partner->is_verified == 1): ?>
                                                    <a href="<?php echo e(route('admin.approval.partner_info', $partner->hashid)); ?>" class="button button-small" style="color: #0065e6;">
                                                        <i class="fa fa-info-circle"></i>
                                                    </a>
                                                    <?php elseif($partner->is_verified == 0): ?>
                                                        -
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    
    <div class="modal fade" id="partnerModal" tabindex="-1" role="dialog" aria-labelledby="partnerModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="partnerModalLabel">Partner Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p><strong>Institute Name:</strong> <span id="Institute_Name"></span></p>
                    <p><strong>Head Institute:</strong> <span id="head_institute"></span></p>
                    <p><strong>Phone Number:</strong> <span id="phone_number"></span></p>
                    <p><strong>Email:</strong> <span id="email"></span></p>
                    <p><strong>Address:</strong> <span id="address"></span></p>
                    <p><strong>City:</strong> <span id="city"></span></p>
                    <p><strong>Country:</strong> <span id="country"></span></p>
                    <p><strong>Website:</strong> <span id="website"></span></p>
                    <p><strong>Business Registration:</strong> <span id="business_registration"></span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Approve Modal -->
    <div class="modal fade" id="approveModal" tabindex="-1" role="dialog" aria-labelledby="approveModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="approveModalLabel">Approve Partner</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to approve <strong id="partnerName"></strong></p>
                    <form id="approvalForm" action="<?php echo e(route('admin.approval.update-approval-status')); ?>" class="ajaxForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id" id="partnerId">
                        <input type="hidden" name="approved" id="approvedType">
                        <div class="d-flex justify-content-between w-100">
                            <button type="submit" class="btn btn-primary" data-approve-type="withPayment">Approve with
                                Payment</button>
                            <button type="submit" class="btn btn-primary" data-approve-type="withoutPayment">Approve
                                without Payment</button>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <!-- Jquery DataTable Plugin Js -->
    <script src="<?php echo e(asset('front')); ?>/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/js/pages/tables/jquery-datatable.js"></script>
    <script>
        $('#partnerModal').on('hidden.bs.modal', function() {
            $('.modal-backdrop').remove();
        });
        $('#approveModal').on('hidden.bs.modal', function() {
            $('.modal-backdrop').remove();
        });

        $(document).on('click', '.view_partner_details', function() {
            let data = $(this).data('data');
            $('#Institute_Name').html(data.institute_name);
            $('#head_institute').html(data.head_institute);
            $('#phone_number').html(data.phone_number);
            $('#email').html(data.email);
            $('#address').html(data.address);
            $('#city').html(data.city);
            $('#country').html(data.country);
            $('#website').html(data.website);
            $('#business_registration').html(data.business_registration);
            $('#partnerModal').modal({
                backdrop: 'static',
                backdrop: false
            });
            $('#partnerModal').modal('show');
        });

        $(document).on('click', '.approveModal', function() {
            var partner = $(this).data('data');
            $('#partnerName').text(partner.institute_name + '?');
            $('#partnerId').val(partner.id);
            $('#approveModal').modal({
                backdrop: 'static',
                backdrop: false
            });
            $('#approveModal').modal('show');
        });

        $('#approvalForm').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr('action');

            var formData = $(this).serialize();
            my_ajax(url, formData, 'get', function(res) {

            }, true);
        })

        $(document).on('click', '[data-approve-type]', function() {
            var type = $(this).data('approve-type');
            setApproveType(type);
        });

        function setApproveType(type) {
            if (type === 'withPayment') {
                $('#approvedType').val('withPayment');
            } else if (type === 'withoutPayment') {
                $('#approvedType').val('withoutPayment');
            }
        }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\oshta_new\resources\views/admin/approval_partner.blade.php ENDPATH**/ ?>