<style>
    .card {
    position: relative;
}

.icon-link {
    position: absolute;
    top: 10px; /* Adjust as needed */
    right: 10px; /* Adjust as needed */
    cursor: pointer;
}

.dropdown-menu {
    display: none;
    position: absolute;
    top: 100%; /* Position below the icon */
    right: 0;
    background-color: #fff;
    border: 1px solid #ddd;
    border-radius: 4px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
    z-index: 10;
}

.dropdown-menu.show {
    display: block;
}

.dropdown-menu a {
    display: block;
    padding: 8px 16px;
    color: #333;
    text-decoration: none;
    font-size: 14px;
}

.dropdown-menu a:hover {
    background-color: #f0f0f0;
}

.icon-link i {
    font-size: 20px;
}
</style>

<?php $__env->startSection('page-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/dataTables.bootstrap4.min.css">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="container-fluid">
            <div class="block-header">
                <div class="row clearfix">
                    <div class="col-lg-5 col-md-5 col-sm-12">
                        <h2><?php echo e($title); ?></h2>
                        <ul class="breadcrumb padding-0">
                            <li class="breadcrumb-item"><a href="index.html"><i class="zmdi zmdi-home"></i></a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.home')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
            <!-- Basic Examples -->
            <div class="row clearfix">
                <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="card text-center position-relative">
                        <div class="body position-relative" style="height: 400px;">
                            <!-- Positioned icon link -->
                            <div class="icon-link">
                                <i class="fas fa-ellipsis-h"></i>
                                <div class="dropdown-menu">
                                    <a href="<?php echo e(route('admin.exam.edit', $card->hashid)); ?>" class="edit-link" title="Edit">
                                        <i class="fas fa-edit"></i> Edit
                                    </a>
                                    <a class="delete-link" href="javascript:void(0)" onclick="ajaxRequest(this)" data-url="<?php echo e(route('admin.exam.delete', $card->hashid)); ?>" title="Delete">
                                        <i class="fas fa-trash"></i>Delete</a>
                                </div>
                            </div>
                            <p class="m-b-20">
                                <i class="fas fa-graduation-cap zmdi-hc-3x col-primary"></i>
                            </p>
                            <h4 class="m-b-10"><?php echo e($card->title); ?></h4>
                            <p class="">
                                Card: <?php echo e($card->card->title); ?> 
                            </p>
                            <p class="">
                                Total Questions: <?php echo e($card->questions_count); ?>

                            </p>
                            <p class="">
                                Exam Questions: 50
                            </p>
                            <p class="">
                                Created At: <?php echo e(date('d M, Y', strtotime($card->created_at))); ?>

                            </p>
                            <p class="">
                                Status: <span class="badge badge-success"><?php echo e($card->status); ?></span>
                            </p>
                            <p class="">
                                <i class="fa fa-clock"></i> Time: <?php echo e($card->time); ?>

                            </p>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-scripts'); ?>
    <!-- Jquery DataTable Plugin Js -->
    <script src="<?php echo e(asset('front')); ?>/assets/bundles/datatablescripts.bundle.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/dataTables.buttons.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.bootstrap4.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.colVis.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.html5.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/plugins/jquery-datatable/buttons/buttons.print.min.js"></script>
    <script src="<?php echo e(asset('front')); ?>/assets/js/pages/tables/jquery-datatable.js"></script>

    <!-- Custom Script for Dropdown Toggle -->
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            document.querySelectorAll('.icon-link').forEach(iconLink => {
                iconLink.addEventListener('click', (event) => {
                    event.stopPropagation();
                    const menu = iconLink.querySelector('.dropdown-menu');
                    menu.classList.toggle('show');
                });
            });

            document.addEventListener('click', () => {
                document.querySelectorAll('.dropdown-menu.show').forEach(menu => {
                    menu.classList.remove('show');
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\oshta_new\resources\views/admin/exam/exam_card.blade.php ENDPATH**/ ?>